/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator.plantuml;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingModel;
import org.contextmapper.dsl.contextMappingDSL.Feature;
import org.contextmapper.dsl.contextMappingDSL.UseCase;
import org.contextmapper.dsl.contextMappingDSL.UserRequirement;
import org.contextmapper.dsl.generator.plantuml.AbstractPlantUMLDiagramCreator;
import org.contextmapper.dsl.generator.plantuml.PlantUMLDiagramCreator;

public class PlantUMLUseCaseDiagramCreator
extends AbstractPlantUMLDiagramCreator<ContextMappingModel>
implements PlantUMLDiagramCreator<ContextMappingModel> {
    private Set<String> useCasesAndStories;
    private Set<Actor> actors;
    private Set<Actor> secondaryActors;
    private int actorCounter = 0;

    @Override
    protected void printDiagramContent(ContextMappingModel model) {
        this.prepareData((List<UserRequirement>)model.getUserRequirements());
        this.printUseCases();
        this.linebreak();
        this.printActors(this.actors);
        this.printActors(this.secondaryActors);
        this.linebreak();
        this.sb.append("left to right direction");
        this.linebreak();
        this.printConnections(this.actors, false);
        this.printConnections(this.secondaryActors, true);
        this.linebreak();
        this.printNotes((List<UserRequirement>)model.getUserRequirements());
    }

    private void printUseCases() {
        for (String useCase : this.useCasesAndStories) {
            this.sb.append("\"").append(useCase).append("\"").append(" as ").append("(").append(useCase).append(")");
            this.linebreak();
        }
    }

    private void printActors(Set<Actor> actors) {
        for (Actor actor : actors) {
            this.sb.append("\"").append(actor.name).append("\"").append(" as ").append(actor.id);
            this.linebreak();
        }
    }

    private void printConnections(Set<Actor> actors, boolean secondaryActors) {
        for (Actor actor : actors) {
            this.printActorsConnections(actor, secondaryActors);
        }
    }

    private void printActorsConnections(Actor actor, boolean secondaryActor) {
        for (String useCase : actor.connectedUseCasesAndStories) {
            if (!secondaryActor) {
                this.sb.append(actor.id).append(" -- ").append(useCase);
            } else {
                this.sb.append(useCase).append(" -- ").append(actor.id);
            }
            this.linebreak();
        }
    }

    private void printNotes(List<UserRequirement> userRequirements) {
        for (UserRequirement req : userRequirements) {
            this.printNoteIfAvailable(req);
        }
    }

    private void printNoteIfAvailable(UserRequirement requirement) {
        ArrayList<CallSite> lines = new ArrayList<CallSite>();
        if (requirement instanceof UseCase && ((UseCase)requirement).getScope() != null && !"".equals(((UseCase)requirement).getScope())) {
            lines.add((CallSite)((Object)("//Scope:// " + ((UseCase)requirement).getScope())));
        }
        if (requirement instanceof UseCase && ((UseCase)requirement).getLevel() != null && !"".equals(((UseCase)requirement).getLevel())) {
            lines.add((CallSite)((Object)("//Level:// " + ((UseCase)requirement).getLevel())));
        }
        for (Feature feature : requirement.getFeatures()) {
            lines.add((CallSite)((Object)("//Feature:// " + this.getFeatureString(feature))));
        }
        if (requirement.getBenefit() != null && !"".equals(requirement.getBenefit())) {
            lines.add((CallSite)((Object)("//Benefit:// " + requirement.getBenefit())));
        }
        if (!lines.isEmpty()) {
            this.sb.append("note bottom of (").append(requirement.getName().trim()).append(")");
            this.linebreak();
            for (String line : lines) {
                this.sb.append("  ").append(line);
                this.linebreak();
            }
            this.sb.append("end note");
            this.linebreak();
        }
    }

    private String getFeatureString(Feature feature) {
        StringBuilder sb = new StringBuilder();
        sb.append(feature.getVerb());
        sb.append(" ");
        if (feature.getEntityArticle() != null && !"".equals(feature.getEntityArticle())) {
            sb.append(feature.getEntityArticle());
            sb.append(" ");
        }
        sb.append(feature.getEntity());
        if (feature.getContainerEntity() != null && !"".equals(feature.getContainerEntity())) {
            sb.append(" ");
            if (feature.getContainerEntityPreposition() != null && !"".equals(feature.getContainerEntityPreposition())) {
                sb.append(feature.getContainerEntityPreposition());
                sb.append(" ");
            }
            if (feature.getContainerEntityArticle() != null && !"".equals(feature.getContainerEntityArticle())) {
                sb.append(feature.getContainerEntityArticle());
                sb.append(" ");
            }
            sb.append(feature.getContainerEntity());
        }
        return sb.toString();
    }

    private void prepareData(List<UserRequirement> userRequirements) {
        this.initializeDataStructures();
        for (UserRequirement req : userRequirements) {
            Actor primaryActor = this.getActorForName(req.getRole().trim());
            this.useCasesAndStories.add(req.getName().trim());
            primaryActor.addUseCaseOrStory(req.getName().trim());
            if (!(req instanceof UseCase)) continue;
            this.initSecondaryActors((List<String>)((UseCase)req).getSecondaryActors(), req.getName().trim());
        }
    }

    private void initSecondaryActors(List<String> actorNames, String useCaseOrStoryName) {
        for (String name : actorNames) {
            Actor secondaryActor = this.getActorSecondaryForName(name.trim());
            secondaryActor.addUseCaseOrStory(useCaseOrStoryName);
        }
    }

    private void initializeDataStructures() {
        this.useCasesAndStories = new TreeSet<String>();
        this.actors = new TreeSet<Actor>();
        this.secondaryActors = new TreeSet<Actor>();
        this.actorCounter = 0;
    }

    private Actor getActorForName(String actorName) {
        return this.getActorForName(actorName, this.actors);
    }

    private Actor getActorSecondaryForName(String actorName) {
        return this.getActorForName(actorName, this.secondaryActors);
    }

    private Actor getActorForName(String actorName, Set<Actor> actors) {
        Optional<Actor> potentiallyExistingActor = actors.stream().filter(a -> a.name.equals(actorName)).findFirst();
        if (potentiallyExistingActor.isPresent()) {
            return potentiallyExistingActor.get();
        }
        Actor actor = new Actor(actorName, "Actor_" + this.actorCounter++);
        actors.add(actor);
        return actor;
    }

    private class Actor
    implements Comparable<Actor> {
        private String name;
        private String id;
        private Set<String> connectedUseCasesAndStories;

        private Actor(String name, String id) {
            this.name = name;
            this.id = id;
            this.connectedUseCasesAndStories = new TreeSet<String>();
        }

        private void addUseCaseOrStory(String useCaseOrStoryName) {
            this.connectedUseCasesAndStories.add(useCaseOrStoryName);
        }

        @Override
        public int compareTo(Actor otherActor) {
            return this.id.compareTo(otherActor.id);
        }
    }
}

