/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator.plantuml;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import org.contextmapper.dsl.contextMappingDSL.AbstractStakeholder;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.Stakeholder;
import org.contextmapper.dsl.contextMappingDSL.StakeholderGroup;
import org.contextmapper.dsl.contextMappingDSL.Stakeholders;
import org.contextmapper.dsl.generator.plantuml.AbstractPlantUMLMindMapDiagramCreator;
import org.contextmapper.dsl.generator.plantuml.PlantUMLDiagramCreator;

public class PlantUMLStakeholderMapGenerator
extends AbstractPlantUMLMindMapDiagramCreator<Stakeholders>
implements PlantUMLDiagramCreator<Stakeholders> {
    private static final String STAR = "*";
    private List<AbstractStakeholder> left = Lists.newArrayList();
    private List<AbstractStakeholder> right = Lists.newArrayList();

    @Override
    protected void printDiagramContent(Stakeholders stakeholders) {
        this.initData(stakeholders);
        this.printStyles();
        this.sb.append(STAR).append(" ").append(this.getStakeholderDiagramContextName((List<BoundedContext>)stakeholders.getContexts()));
        this.linebreak();
        this.printStakeholders(this.right);
        this.linebreak();
        this.sb.append("left side");
        this.linebreak();
        this.printStakeholders(this.left);
    }

    private void printStyles() {
        this.sb.append("<style>");
        this.linebreak();
        this.sb.append("node {");
        this.linebreak();
        this.sb.append("    MaximumWidth 300");
        this.linebreak();
        this.sb.append("}");
        this.linebreak();
        this.sb.append("</style>");
        this.linebreak(2);
    }

    public String getStakeholderDiagramContextName(List<BoundedContext> bcs) {
        if (bcs != null && !bcs.isEmpty()) {
            return String.join((CharSequence)", ", bcs.stream().map(bc -> bc.getName()).collect(Collectors.toList()));
        }
        return "System of Interest";
    }

    private void printStakeholders(List<AbstractStakeholder> stakeholders) {
        for (AbstractStakeholder s : stakeholders) {
            if (s instanceof StakeholderGroup) {
                this.printStakeholderGroup((StakeholderGroup)s);
                continue;
            }
            if (!(s instanceof Stakeholder)) continue;
            this.printGeneralStakeholderLine(2, s.getName(), ((Stakeholder)s).getDescription());
        }
    }

    private void printStakeholderGroup(StakeholderGroup group) {
        this.printGeneralStakeholderLine(2, group.getName(), null);
        for (Stakeholder s : group.getStakeholders()) {
            this.printGeneralStakeholderLine(3, s.getName(), s.getDescription());
        }
    }

    private void printGeneralStakeholderLine(int level, String name, String description) {
        for (int i = 0; i < level; ++i) {
            this.sb.append(STAR);
        }
        if (description != null && !"".equals(description)) {
            this.sb.append(":<b>").append(name).append("</b>");
            this.linebreak();
            this.sb.append("----");
            this.linebreak();
            this.sb.append(description).append(";");
        } else {
            this.sb.append(" <b>").append(name).append("</b>");
        }
        this.linebreak();
    }

    private void initData(Stakeholders stakeholders) {
        this.left.clear();
        this.right.clear();
        boolean addLeft = true;
        for (AbstractStakeholder s : stakeholders.getStakeholders()) {
            if (addLeft) {
                this.left.add(s);
            } else {
                this.right.add(s);
            }
            addLeft = !addLeft;
        }
    }
}

