/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator.plantuml;

import com.google.common.collect.Sets;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class AssociationLink {
    private String participant1;
    private String participant2;
    private String label;

    public AssociationLink(String participant1, String participant2, String label) {
        this.participant1 = participant1;
        this.participant2 = participant2;
        this.label = label;
    }

    public String getFirstParticipant() {
        return this.participant1;
    }

    public String getSecondParticipant() {
        return this.participant2;
    }

    public String getLabel() {
        return this.label;
    }

    public int hashCode() {
        return Objects.hash(this.label, this.createParticipantSet(this));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AssociationLink other = (AssociationLink)obj;
        return Objects.equals(this.label, other.label) && Objects.equals(this.createParticipantSet(this), this.createParticipantSet(other));
    }

    private Set<String> createParticipantSet(AssociationLink association) {
        TreeSet participants = Sets.newTreeSet();
        participants.add(association.participant1);
        participants.add(association.participant2);
        return participants;
    }

    public boolean isSelfReference() {
        return this.participant1.equals(this.participant2);
    }
}

