/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator.plantuml;

import org.contextmapper.dsl.generator.plantuml.PlantUMLDiagramCreator;
import org.eclipse.emf.ecore.EObject;

public abstract class AbstractPlantUMLMindMapDiagramCreator<T extends EObject>
implements PlantUMLDiagramCreator<T> {
    protected StringBuilder sb = new StringBuilder();

    @Override
    public String createDiagram(T modelObject) {
        this.printHeader();
        this.printDiagramContent(modelObject);
        this.printFooter();
        return this.sb.toString();
    }

    protected abstract void printDiagramContent(T var1);

    protected void printHeader() {
        this.sb.append("@startmindmap");
        this.linebreak(2);
    }

    protected void printFooter() {
        this.linebreak(2);
        this.sb.append("@endmindmap");
        this.linebreak();
    }

    protected void linebreak() {
        this.sb.append(System.lineSeparator());
    }

    protected void linebreak(int amount) {
        for (int i = 0; i < amount; ++i) {
            this.linebreak();
        }
    }
}

