/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator.mdsl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.contextmapper.dsl.contextMappingDSL.Aggregate;
import org.contextmapper.dsl.contextMappingDSL.Application;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.CommandInvokationStep;
import org.contextmapper.dsl.contextMappingDSL.ConcurrentCommandInvokation;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingModel;
import org.contextmapper.dsl.contextMappingDSL.DomainEventProductionStep;
import org.contextmapper.dsl.contextMappingDSL.EitherCommandOrOperation;
import org.contextmapper.dsl.contextMappingDSL.EitherCommandOrOperationInvokation;
import org.contextmapper.dsl.contextMappingDSL.EventProduction;
import org.contextmapper.dsl.contextMappingDSL.ExclusiveAlternativeCommandInvokation;
import org.contextmapper.dsl.contextMappingDSL.ExclusiveAlternativeEventProduction;
import org.contextmapper.dsl.contextMappingDSL.Flow;
import org.contextmapper.dsl.contextMappingDSL.FlowStep;
import org.contextmapper.dsl.contextMappingDSL.InclusiveAlternativeCommandInvokation;
import org.contextmapper.dsl.contextMappingDSL.InclusiveAlternativeEventProduction;
import org.contextmapper.dsl.contextMappingDSL.MultipleEventProduction;
import org.contextmapper.dsl.contextMappingDSL.SingleCommandInvokation;
import org.contextmapper.dsl.contextMappingDSL.SingleEventProduction;
import org.contextmapper.dsl.contextMappingDSL.UpstreamDownstreamRelationship;
import org.contextmapper.dsl.contextMappingDSL.UpstreamRole;
import org.contextmapper.dsl.contextMappingDSL.impl.CommandInvokationStepImpl;
import org.contextmapper.dsl.contextMappingDSL.impl.DomainEventProductionStepImpl;
import org.contextmapper.dsl.generator.exception.GeneratorInputException;
import org.contextmapper.dsl.generator.exception.InputNotYetSupportedException;
import org.contextmapper.dsl.generator.mdsl.MDSLDataTypeCreator;
import org.contextmapper.dsl.generator.mdsl.MDSLNameEncoder;
import org.contextmapper.dsl.generator.mdsl.MDSLPatternMatcher;
import org.contextmapper.dsl.generator.mdsl.generatorcontext.DownstreamContext;
import org.contextmapper.dsl.generator.mdsl.generatorcontext.UpstreamAPIContext;
import org.contextmapper.dsl.generator.mdsl.model.APIUsageContext;
import org.contextmapper.dsl.generator.mdsl.model.DataType;
import org.contextmapper.dsl.generator.mdsl.model.EndpointClient;
import org.contextmapper.dsl.generator.mdsl.model.EndpointContract;
import org.contextmapper.dsl.generator.mdsl.model.EndpointOffer;
import org.contextmapper.dsl.generator.mdsl.model.EndpointOperation;
import org.contextmapper.dsl.generator.mdsl.model.EndpointProvider;
import org.contextmapper.dsl.generator.mdsl.model.OrchestrationFlow;
import org.contextmapper.dsl.generator.mdsl.model.ServiceSpecification;
import org.contextmapper.tactic.dsl.tacticdsl.CollectionType;
import org.contextmapper.tactic.dsl.tacticdsl.CommandEvent;
import org.contextmapper.tactic.dsl.tacticdsl.ComplexType;
import org.contextmapper.tactic.dsl.tacticdsl.DomainEvent;
import org.contextmapper.tactic.dsl.tacticdsl.DomainObject;
import org.contextmapper.tactic.dsl.tacticdsl.DomainObjectOperation;
import org.contextmapper.tactic.dsl.tacticdsl.Parameter;
import org.contextmapper.tactic.dsl.tacticdsl.ServiceOperation;
import org.contextmapper.tactic.dsl.tacticdsl.SimpleDomainObject;
import org.contextmapper.tactic.dsl.tacticdsl.TacticdslFactory;
import org.contextmapper.tactic.dsl.tacticdsl.Visibility;
import org.eclipse.emf.common.util.EList;

public class MDSLModelCreator {
    private static final String API_NAME_EXTENSION = "API";
    private static final String PROVIDER_NAME_EXTENSION = "Provider";
    private static final String CLIENT_NAME_EXTENSION = "Client";
    private static final String MDSL_VOID_RETURN_TYPE = "D<void>";
    private static final String ENDPOINT_LOCATION = "http://localhost:";
    private static final String PROTOCOL_STRING_IF_NOT_DEFINED = "tbd";
    private static final String PROTOCOL_NOT_DEFINED_COMMENT = "The protocol is generated if you specify the implementation technology in CML";
    private ContextMappingModel model;
    private int initialPort = 8000;
    private MDSLDataTypeCreator dataTypeCreator;
    private MDSLNameEncoder mdslEncoder;

    public MDSLModelCreator(ContextMappingModel model) {
        this.model = model;
        this.dataTypeCreator = new MDSLDataTypeCreator();
        this.mdslEncoder = new MDSLNameEncoder();
    }

    public List<ServiceSpecification> createServiceSpecifications() {
        this.checkPreconditions();
        ArrayList specs = Lists.newArrayList();
        Map<String, UpstreamAPIContext> upstreamContexts = this.collectUpstreamContexts();
        for (String apiName : upstreamContexts.keySet()) {
            UpstreamAPIContext context = upstreamContexts.get(apiName);
            specs.add(this.createServiceSpecification(context.getApiName(), context));
        }
        return specs;
    }

    private ServiceSpecification createServiceSpecification(String apiName, UpstreamAPIContext context) {
        ServiceSpecification specification = new ServiceSpecification();
        specification.setName(this.mdslEncoder.encodeName(apiName));
        if (context.getUpstreamRoles().contains((Object)UpstreamRole.OPEN_HOST_SERVICE) && context.getUpstreamRoles().contains((Object)UpstreamRole.PUBLISHED_LANGUAGE)) {
            specification.setUsageContext(APIUsageContext.PUBLIC_API);
        } else if (context.getUpstreamRoles().contains((Object)UpstreamRole.OPEN_HOST_SERVICE)) {
            specification.setUsageContext(APIUsageContext.COMMUNITY_API);
        }
        if (context.getApplicationLayer() != null) {
            specification.addEndpoint(this.createEndpoint(context.getApplicationLayer(), specification));
            for (DomainEvent de : context.getApplicationLayer().getEvents()) {
                specification.addEventType(de.getName());
            }
            for (Aggregate exposedAggregate : context.getExposedAggregates()) {
                for (SimpleDomainObject objectInAggregate : exposedAggregate.getDomainObjects()) {
                    if (!(objectInAggregate instanceof DomainEvent)) continue;
                    DomainEvent de = (DomainEvent)objectInAggregate;
                    specification.addEventType(de.getName());
                }
            }
            for (Object ce : context.getApplicationLayer().getCommands()) {
                specification.addCommandType(ce.getName());
            }
            EList<Flow> flows = context.getApplicationLayer().getFlows();
            for (Flow cmlFlow : flows) {
                OrchestrationFlow mdslFlow = new OrchestrationFlow();
                mdslFlow.setName(cmlFlow.getName());
                for (FlowStep step : cmlFlow.getSteps()) {
                    this.mapFlowStep(mdslFlow, step);
                }
                specification.addFlow(mdslFlow);
            }
        }
        for (Aggregate aggregate : context.getExposedAggregates()) {
            specification.addEndpoint(this.createEndpoint(aggregate, specification));
        }
        for (DataType dataType : this.dataTypeCreator.getAllDataTypes()) {
            specification.addDataType(dataType);
        }
        specification.addProvider(this.createProvider(context, specification.getEndpoints()));
        for (DownstreamContext downstreamContext : context.getDownstreamContexts()) {
            specification.addClient(this.createClient(downstreamContext));
        }
        return specification;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void mapFlowStep(OrchestrationFlow mdslFlow, FlowStep step) {
        if (step.getClass() == CommandInvokationStepImpl.class) {
            CommandInvokationStep cis = (CommandInvokationStep)step;
            EitherCommandOrOperationInvokation ecooi = cis.getAction();
            EList<DomainEvent> events = cis.getEvents();
            if (ecooi instanceof SingleCommandInvokation) {
                SingleCommandInvokation ci = (SingleCommandInvokation)ecooi;
                String andEvents = this.combineEvents(events, " + ");
                Object commands = "";
                boolean first = true;
                for (CommandEvent ce : ci.getCommands()) {
                    if (!first) {
                        commands = (String)commands + "-";
                        first = false;
                    }
                    commands = (String)commands + ce.getName();
                }
                mdslFlow.addCommandInvocationStep(andEvents, (String)commands);
                return;
            } else if (ecooi instanceof ConcurrentCommandInvokation) {
                ConcurrentCommandInvokation cci = (ConcurrentCommandInvokation)ecooi;
                EList<CommandEvent> commands = cci.getCommands();
                String andEvents = this.combineEvents(events, " + ");
                Object andCommands = ((CommandEvent)commands.get(0)).getName();
                for (int i = 1; i < commands.size(); ++i) {
                    andCommands = (String)andCommands + " + " + ((CommandEvent)commands.get(i)).getName();
                }
                mdslFlow.addCommandInvocationStep(andEvents, (String)andCommands);
                return;
            } else if (ecooi instanceof ExclusiveAlternativeCommandInvokation) {
                ExclusiveAlternativeCommandInvokation eaci = (ExclusiveAlternativeCommandInvokation)ecooi;
                EList<CommandEvent> commands = eaci.getCommands();
                String xorEvents = this.combineEvents(events, " + ");
                Object xorCommands = ((CommandEvent)commands.get(0)).getName();
                for (int i = 1; i < commands.size(); ++i) {
                    xorCommands = (String)xorCommands + " x " + ((CommandEvent)commands.get(i)).getName();
                }
                mdslFlow.addCommandInvocationStep(xorEvents, (String)xorCommands);
                return;
            } else {
                if (!(ecooi instanceof InclusiveAlternativeCommandInvokation)) throw new GeneratorInputException("Not yet implemented: support for " + ecooi.getClass());
                InclusiveAlternativeCommandInvokation eaci = (InclusiveAlternativeCommandInvokation)ecooi;
                EList<CommandEvent> commands = eaci.getCommands();
                String orEvents = this.combineEvents(events, " + ");
                Object orCommands = ((CommandEvent)commands.get(0)).getName();
                for (int i = 1; i < commands.size(); ++i) {
                    orCommands = (String)orCommands + " o " + ((CommandEvent)commands.get(i)).getName();
                }
                mdslFlow.addCommandInvocationStep(orEvents, (String)orCommands);
            }
            return;
        } else {
            if (step.getClass() != DomainEventProductionStepImpl.class) return;
            DomainEventProductionStep depStep = (DomainEventProductionStep)step;
            EitherCommandOrOperation action = depStep.getAction();
            EventProduction ep = depStep.getEventProduction();
            if (action.getCommand() == null && action.getOperation() != null) {
                throw new InputNotYetSupportedException("Operations are not yet supported in the MDSL generator. Please use commands instead.");
            }
            if (ep instanceof SingleEventProduction) {
                EList<DomainEvent> events = ep.getEvents();
                if (events.size() != 1) {
                    throw new InvalidParameterException("Single event production must not list more than one event.");
                }
                mdslFlow.addEventProductionStep(action.getCommand().getName(), ((DomainEvent)events.get(0)).getName());
                return;
            } else if (ep instanceof MultipleEventProduction) {
                String andEvents = this.mapEvents(action, ep, " + ");
                mdslFlow.addEventProductionStep(action.getCommand().getName(), andEvents);
                return;
            } else if (ep instanceof InclusiveAlternativeEventProduction) {
                String orEvents = this.mapEvents(action, ep, " o ");
                mdslFlow.addEventProductionStep(action.getCommand().getName(), orEvents);
                return;
            } else {
                if (!(ep instanceof ExclusiveAlternativeEventProduction)) throw new GeneratorInputException("Not yet implemented: support for " + ep.getClass());
                String xorEvents = this.mapEvents(action, ep, " x ");
                mdslFlow.addEventProductionStep(action.getCommand().getName(), xorEvents);
            }
        }
    }

    private String mapEvents(EitherCommandOrOperation action, EventProduction ep, String operator) {
        EList<DomainEvent> events = ep.getEvents();
        Object combinedEvents = ((DomainEvent)events.get(0)).getName();
        for (int i = 1; i < events.size(); ++i) {
            if (action.getCommand() == null) {
                throw new GeneratorInputException("Operations are not supported in MDSL");
            }
            combinedEvents = (String)combinedEvents + operator + ((DomainEvent)events.get(i)).getName();
        }
        return combinedEvents;
    }

    private String combineEvents(EList<DomainEvent> events, String operator) {
        Object combinedEvent = "";
        boolean isFirstElementInList = true;
        for (DomainEvent event : events) {
            if (isFirstElementInList) {
                isFirstElementInList = false;
            } else {
                combinedEvent = (String)combinedEvent + operator;
            }
            combinedEvent = (String)combinedEvent + event.getName();
        }
        return combinedEvent;
    }

    private EndpointContract createEndpoint(Aggregate aggregate, ServiceSpecification specification) {
        EndpointContract endpoint = new EndpointContract();
        String endpointName = this.mdslEncoder.encodeName(aggregate.getName());
        endpoint.setName(endpointName);
        Optional<DomainObject> aggregateRoot = aggregate.getDomainObjects().stream().filter(o -> o instanceof DomainObject).map(o -> (DomainObject)o).filter(o -> o.isAggregateRoot()).findFirst();
        if (aggregateRoot.isPresent()) {
            for (DomainObjectOperation operation : aggregateRoot.get().getOperations()) {
                if (!operation.getVisibility().equals((Object)Visibility.PUBLIC)) continue;
                endpoint.addOperation(this.createOperation(operation, specification));
            }
        }
        List serviceOperations = aggregate.getServices().stream().flatMap(s -> s.getOperations().stream()).collect(Collectors.toList());
        for (ServiceOperation serviceOperation : serviceOperations) {
            if (!serviceOperation.getVisibility().equals((Object)Visibility.PUBLIC)) continue;
            endpoint.addOperation(this.createOperation(serviceOperation, specification));
        }
        this.setEndpointServesAsString(endpoint, aggregate.getDoc());
        return endpoint;
    }

    private EndpointContract createEndpoint(Application application, ServiceSpecification specification) {
        EndpointContract endpoint = new EndpointContract();
        String endpointName = StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{application.getName()}) ? this.mdslEncoder.encodeName(application.getName()) : this.mdslEncoder.encodeName("Application");
        endpoint.setName(endpointName);
        List serviceOperations = application.getServices().stream().flatMap(s -> s.getOperations().stream()).collect(Collectors.toList());
        for (ServiceOperation serviceOperation : serviceOperations) {
            if (!serviceOperation.getVisibility().equals((Object)Visibility.PUBLIC)) continue;
            endpoint.addOperation(this.createOperation(serviceOperation, specification));
        }
        for (CommandEvent command : application.getCommands()) {
            endpoint.addOperation(this.createOperation(command, specification));
        }
        return endpoint;
    }

    private void setEndpointServesAsString(EndpointContract endpoint, String docString) {
        if (docString == null || "".equals(docString)) {
            return;
        }
        String pattern = new MDSLPatternMatcher().matchPatterns(MDSLPatternMatcher.ENDPOINT_SERVES_AS_PATTERNS, docString);
        if (!"".equals(pattern)) {
            endpoint.setServesAsPatternMatched(true);
            endpoint.setServesAs(pattern);
        } else {
            endpoint.setServesAs(docString);
        }
    }

    private EndpointOperation createOperation(DomainObjectOperation domainObjectOperation, ServiceSpecification specification) {
        return this.createOperation(domainObjectOperation.getName(), (List<Parameter>)domainObjectOperation.getParameters(), domainObjectOperation.getReturnType(), specification, domainObjectOperation.getDoc());
    }

    private EndpointOperation createOperation(ServiceOperation serviceOperation, ServiceSpecification specification) {
        return this.createOperation(serviceOperation.getName(), (List<Parameter>)serviceOperation.getParameters(), serviceOperation.getReturnType(), specification, serviceOperation.getDoc());
    }

    private EndpointOperation createOperation(CommandEvent command, ServiceSpecification specification) {
        String name = command.getName();
        Parameter parameter = TacticdslFactory.eINSTANCE.createParameter();
        parameter.setName(name + "Parameter");
        ComplexType type = TacticdslFactory.eINSTANCE.createComplexType();
        if (!command.getName().endsWith("Command")) {
            command.setName(command.getName() + "Command");
        }
        type.setDomainObjectType(command);
        parameter.setParameterType(type);
        ArrayList parameters = Lists.newArrayList();
        parameters.add(parameter);
        return this.createOperation(name, parameters, null, specification, "");
    }

    private EndpointOperation createOperation(String operationName, List<Parameter> parameters, ComplexType returnType, ServiceSpecification specification, String docString) {
        EndpointOperation operation = new EndpointOperation();
        operation.setName(this.mdslEncoder.encodeName(operationName));
        if (parameters.isEmpty()) {
            operation.setExpectingPayload(this.createVoidReturnType());
        } else if (parameters.size() == 1) {
            Parameter parameter = parameters.get(0);
            operation.setExpectingPayload(this.dataTypeCreator.createMDSLDataType(parameter.getParameterType()));
            operation.setExpectingCollection(parameter.getParameterType().getCollectionType() != CollectionType.NONE);
        } else {
            operation.setExpectingPayload(this.dataTypeCreator.createMDSLDataType4ParameterList(operationName, parameters));
        }
        if (returnType != null) {
            operation.setDeliveringPayload(this.dataTypeCreator.createMDSLDataType(returnType));
            operation.setDeliveringCollection(returnType.getCollectionType() != CollectionType.NONE);
        }
        this.setOperationResponsibility(operation, docString);
        return operation;
    }

    private void setOperationResponsibility(EndpointOperation operation, String docString) {
        if (docString == null || "".equals(docString)) {
            return;
        }
        String pattern = new MDSLPatternMatcher().matchPatterns(MDSLPatternMatcher.OPERATION_RESPONSIBILITY_PATTERNS, docString);
        if (!"".equals(pattern)) {
            operation.setEndpointResponsibilityPatternMatched(true);
            operation.setEndpointResponsibility(pattern);
        } else {
            operation.setEndpointResponsibility(docString);
        }
    }

    private DataType createVoidReturnType() {
        DataType voidType = new DataType();
        voidType.setIsPrimitiveType(true);
        voidType.setName(MDSL_VOID_RETURN_TYPE);
        return voidType;
    }

    private EndpointProvider createProvider(UpstreamAPIContext context, List<EndpointContract> endpointContracts) {
        EndpointProvider provider = new EndpointProvider();
        String implementationTechnology = context.getJoinedImplementationTechnologies();
        provider.setName(this.mdslEncoder.encodeName(context.getUpstreamContext().getName() + PROVIDER_NAME_EXTENSION));
        for (EndpointContract contract : endpointContracts) {
            EndpointOffer offer = new EndpointOffer();
            offer.setOfferedEndpoint(contract);
            offer.setLocation(ENDPOINT_LOCATION + this.initialPort++);
            offer.setProtocol(!"".equals(implementationTechnology) ? implementationTechnology : PROTOCOL_STRING_IF_NOT_DEFINED);
            offer.setProtocolComment(!"".equals(implementationTechnology) ? "" : PROTOCOL_NOT_DEFINED_COMMENT);
            provider.addEndpointOffer(offer);
        }
        if (!context.getUpstreamRoles().isEmpty()) {
            String roles = String.join((CharSequence)" and ", context.getUpstreamRoles().stream().map(ur -> ur.getName() + " (" + ur.getLiteral() + ")").collect(Collectors.toList()));
            provider.addComment("Generated from DDD upstream Bounded Context '" + context.getUpstreamContext().getName() + "' implementing " + roles + ".");
        }
        if (context.getUpstreamContext().getDomainVisionStatement() != null && !"".equals(context.getUpstreamContext().getDomainVisionStatement())) {
            provider.setDomainVisionStatement(context.getUpstreamContext().getDomainVisionStatement());
        }
        return provider;
    }

    private EndpointClient createClient(DownstreamContext downstreamContext) {
        EndpointClient client = new EndpointClient();
        client.setName(this.mdslEncoder.encodeName(downstreamContext.getDownstreamName() + CLIENT_NAME_EXTENSION));
        List endpoints = downstreamContext.getConsumedAggregates().stream().map(agg -> agg.getName()).collect(Collectors.toList());
        for (String offer : endpoints) {
            client.addConsumedOffer(offer);
        }
        if (!downstreamContext.getDownstreamRoles().isEmpty()) {
            String roles = String.join((CharSequence)" and ", downstreamContext.getDownstreamRoles().stream().map(ur -> ur.getName() + " (" + ur.getLiteral() + ")").collect(Collectors.toList()));
            client.addComment("Generated from DDD downstream Bounded Context '" + downstreamContext.getDownstreamName() + "' implementing " + roles + ".");
        }
        if (downstreamContext.getDomainVisionStatement() != null && !"".equals(downstreamContext.getDomainVisionStatement())) {
            client.setDomainVisionStatement(downstreamContext.getDomainVisionStatement());
        }
        return client;
    }

    private Map<String, UpstreamAPIContext> collectUpstreamContexts() {
        UpstreamAPIContext context;
        HashMap upstreamContextMap = Maps.newHashMap();
        List<Object> upstreamDownstreamRelationships = Lists.newLinkedList();
        if (this.model.getMap() != null) {
            upstreamDownstreamRelationships = this.model.getMap().getRelationships().stream().filter(rel -> rel instanceof UpstreamDownstreamRelationship).map(rel -> (UpstreamDownstreamRelationship)rel).collect(Collectors.toList());
        }
        for (UpstreamDownstreamRelationship relationship : upstreamDownstreamRelationships) {
            if (relationship.getUpstreamExposedAggregates().isEmpty()) continue;
            String upstreamAPIName = relationship.getUpstream().getName() + API_NAME_EXTENSION;
            context = null;
            if (upstreamContextMap.containsKey(upstreamAPIName)) {
                context = (UpstreamAPIContext)upstreamContextMap.get(upstreamAPIName);
            } else {
                context = new UpstreamAPIContext();
                context.setApiName(this.mdslEncoder.encodeName(upstreamAPIName));
                context.setUpstreamContext(relationship.getUpstream());
                upstreamContextMap.put(upstreamAPIName, context);
            }
            context.getUpstreamRoles().addAll((Collection<UpstreamRole>)relationship.getUpstreamRoles());
            for (Aggregate exposedAggregate : relationship.getUpstreamExposedAggregates()) {
                if (context.getExposedAggregates().stream().map(agg -> agg.getName()).collect(Collectors.toList()).contains(exposedAggregate.getName())) continue;
                context.getExposedAggregates().add(exposedAggregate);
            }
            if (relationship.getUpstream().getApplication() != null) {
                context.setApplicationLayer(relationship.getUpstream().getApplication());
            }
            context.addDownstreamContext4Relationship(relationship);
            if (relationship.getImplementationTechnology() == null || "".equals(relationship.getImplementationTechnology())) continue;
            context.getImplementationTechnologies().add(relationship.getImplementationTechnology());
        }
        for (BoundedContext bc : this.model.getBoundedContexts()) {
            String apiName = bc.getName() + API_NAME_EXTENSION;
            if (upstreamContextMap.containsKey(apiName) || bc.getAggregates().isEmpty() && bc.getApplication() == null) continue;
            context = new UpstreamAPIContext();
            context.setApiName(apiName);
            context.setUpstreamContext(bc);
            context.getExposedAggregates().addAll((Collection<Aggregate>)bc.getAggregates());
            context.setApplicationLayer(bc.getApplication());
            upstreamContextMap.put(apiName, context);
        }
        return upstreamContextMap;
    }

    private void checkPreconditions() {
        Map<String, UpstreamAPIContext> upstreamContexts = this.collectUpstreamContexts();
        ArrayList exposedAggregates = Lists.newArrayList();
        ArrayList applications = Lists.newArrayList();
        for (UpstreamAPIContext context : upstreamContexts.values()) {
            exposedAggregates.addAll(context.getExposedAggregates());
            if (context.getApplicationLayer() == null) continue;
            applications.add(context.getApplicationLayer());
        }
        if (exposedAggregates.isEmpty() && applications.isEmpty()) {
            throw new GeneratorInputException("None of your upstream-downstream relationships exposes any Aggregates or application layers. Therefore there is nothing to generate. Use the 'exposedAggregates' attribute on your upstream-downstream relationships to specify which Aggregates are exposed by the upstream or model an 'Application' in your upstream.");
        }
        boolean atLeastOneAggregateWithAnOperation = false;
        for (Aggregate exposedAggregate : exposedAggregates) {
            Optional<DomainObject> aggregateRoot = exposedAggregate.getDomainObjects().stream().filter(o -> o instanceof DomainObject).map(o -> (DomainObject)o).filter(o -> o.isAggregateRoot()).findFirst();
            if (aggregateRoot.isPresent() && !aggregateRoot.get().getOperations().isEmpty()) {
                atLeastOneAggregateWithAnOperation = true;
                break;
            }
            List serviceOperations = exposedAggregate.getServices().stream().flatMap(s -> s.getOperations().stream()).collect(Collectors.toList());
            if (serviceOperations.isEmpty()) continue;
            atLeastOneAggregateWithAnOperation = true;
            break;
        }
        for (Application application : applications) {
            if (!application.getCommands().isEmpty()) {
                atLeastOneAggregateWithAnOperation = true;
                break;
            }
            List serviceOperations = application.getServices().stream().flatMap(s -> s.getOperations().stream()).collect(Collectors.toList());
            if (serviceOperations.isEmpty()) continue;
            atLeastOneAggregateWithAnOperation = true;
            break;
        }
        if (!atLeastOneAggregateWithAnOperation) {
            throw new GeneratorInputException("None of your exposed Aggregates contains either Service or 'Aggregate Root' operations/methods. Therefore there is nothing to generate. Add at least one operation/method to the 'Aggregate Root' or to a Service in one of your exposed Aggregates to get a result.");
        }
    }
}

