/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.contextmapper.dsl.cml.CMLModelDomainAndSubdomainResolver;
import org.contextmapper.dsl.contextMappingDSL.Aggregate;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingModel;
import org.contextmapper.dsl.contextMappingDSL.Flow;
import org.contextmapper.dsl.contextMappingDSL.SculptorModule;
import org.contextmapper.dsl.contextMappingDSL.Stakeholders;
import org.contextmapper.dsl.contextMappingDSL.UseCase;
import org.contextmapper.dsl.contextMappingDSL.UserRequirement;
import org.contextmapper.dsl.contextMappingDSL.ValueElicitation;
import org.contextmapper.dsl.contextMappingDSL.ValueRegister;
import org.contextmapper.dsl.generator.AbstractContextMappingModelGenerator;
import org.contextmapper.dsl.generator.exception.GeneratorInputException;
import org.contextmapper.dsl.generator.plantuml.PlantUMLAggregateClassDiagramCreator;
import org.contextmapper.dsl.generator.plantuml.PlantUMLBoundedContextClassDiagramCreator;
import org.contextmapper.dsl.generator.plantuml.PlantUMLComponentDiagramCreator;
import org.contextmapper.dsl.generator.plantuml.PlantUMLModuleClassDiagramCreator;
import org.contextmapper.dsl.generator.plantuml.PlantUMLStakeholderMapGenerator;
import org.contextmapper.dsl.generator.plantuml.PlantUMLStateDiagramCreator4Aggregate;
import org.contextmapper.dsl.generator.plantuml.PlantUMLStateDiagramCreator4Flow;
import org.contextmapper.dsl.generator.plantuml.PlantUMLSubdomainClassDiagramCreator;
import org.contextmapper.dsl.generator.plantuml.PlantUMLUseCaseDiagramCreator;
import org.contextmapper.dsl.generator.plantuml.PlantUMLUseCaseInteractionsSequenceDiagramCreator;
import org.contextmapper.dsl.generator.plantuml.PlantUMLValueImpactMapGenerator;
import org.contextmapper.tactic.dsl.tacticdsl.Enum;
import org.contextmapper.tactic.dsl.tacticdsl.StateTransition;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.generator.IFileSystemAccess2;

public class PlantUMLGenerator
extends AbstractContextMappingModelGenerator {
    private static final String PLANT_UML_FILE_EXT = "puml";
    private CMLModelDomainAndSubdomainResolver subdomainResolver;

    @Override
    protected void generateFromContextMappingModel(ContextMappingModel model, IFileSystemAccess2 fsa, URI inputFileURI) {
        this.subdomainResolver = new CMLModelDomainAndSubdomainResolver(this.contextMappingModel);
        this.checkPreconditions();
        String fileName = inputFileURI.trimFileExtension().lastSegment();
        this.generateComponentDiagramIfContextMapAvailable(model, fsa, fileName);
        this.generateClassAndStateDiagramsForBoundedContexts(model, fsa, fileName);
        this.generateClassDiagramsForSubdomains(fsa, fileName);
        this.generateUseCaseDiagram(model, fsa, fileName);
        this.generateSequenceDiagramsForUseCases(model, fsa, fileName);
        this.generateStakeholderDiagrams(model, fsa, fileName);
        this.generateValueImpactMapsForValueRegisters(model, fsa, fileName);
    }

    private void generateStakeholderDiagrams(ContextMappingModel model, IFileSystemAccess2 fsa, String fileName) {
        int index = 1;
        for (Stakeholders stakeholders : model.getStakeholders()) {
            PlantUMLStakeholderMapGenerator stakeholderDiagramGenerator = new PlantUMLStakeholderMapGenerator();
            fsa.generateFile(fileName + "_BC_" + stakeholderDiagramGenerator.getStakeholderDiagramContextName((List<BoundedContext>)stakeholders.getContexts()).replace(", ", "-").replace(" ", "-") + "_StakeholderMap-" + index++ + ".puml", (CharSequence)stakeholderDiagramGenerator.createDiagram(stakeholders));
        }
    }

    private void generateValueImpactMapsForValueRegisters(ContextMappingModel model, IFileSystemAccess2 fsa, String fileName) {
        for (ValueRegister valueRegister : model.getValueRegisters()) {
            if (valueRegister.getValueClusters().isEmpty() && valueRegister.getValues().isEmpty() || EcoreUtil2.eAllOfType((EObject)valueRegister, ValueElicitation.class).isEmpty()) continue;
            fsa.generateFile(fileName + "_ValueRegister_" + valueRegister.getName() + "_Value-Impact-Map.puml", (CharSequence)new PlantUMLValueImpactMapGenerator().createDiagram(valueRegister));
        }
    }

    private void generateSequenceDiagramsForUseCases(ContextMappingModel model, IFileSystemAccess2 fsa, String fileName) {
        for (UserRequirement userRequirement : model.getUserRequirements()) {
            if (!(userRequirement instanceof UseCase) || userRequirement.getFeatures().isEmpty()) continue;
            fsa.generateFile(fileName + "_UseCase_" + userRequirement.getName() + "_Interactions.puml", (CharSequence)new PlantUMLUseCaseInteractionsSequenceDiagramCreator().createDiagram((UseCase)userRequirement));
        }
    }

    private void generateUseCaseDiagram(ContextMappingModel model, IFileSystemAccess2 fsa, String fileName) {
        if (!model.getUserRequirements().isEmpty()) {
            fsa.generateFile(fileName + "_UseCases.puml", (CharSequence)new PlantUMLUseCaseDiagramCreator().createDiagram(model));
        }
    }

    private void generateClassDiagramsForSubdomains(IFileSystemAccess2 fsa, String fileName) {
        this.subdomainResolver.resolveAllSubdomains().stream().filter(subdomain -> !subdomain.getEntities().isEmpty()).forEach(subdomain -> fsa.generateFile(fileName + "_SD_" + subdomain.getName() + ".puml", (CharSequence)new PlantUMLSubdomainClassDiagramCreator(this.subdomainResolver.resolveDomain4Subdomain(subdomain.getName()).getName()).createDiagram(subdomain)));
    }

    private void generateClassAndStateDiagramsForBoundedContexts(ContextMappingModel model, IFileSystemAccess2 fsa, String fileName) {
        for (BoundedContext boundedContext : model.getBoundedContexts()) {
            fsa.generateFile(fileName + "_BC_" + boundedContext.getName() + ".puml", (CharSequence)new PlantUMLBoundedContextClassDiagramCreator().createDiagram(boundedContext));
            for (Aggregate aggregate : boundedContext.getAggregates()) {
                fsa.generateFile(fileName + "_BC_" + boundedContext.getName() + "_" + aggregate.getName() + ".puml", (CharSequence)new PlantUMLAggregateClassDiagramCreator().createDiagram(aggregate));
            }
            for (SculptorModule module : boundedContext.getModules()) {
                fsa.generateFile(fileName + "_BC_" + boundedContext.getName() + "_" + module.getName() + ".puml", (CharSequence)new PlantUMLModuleClassDiagramCreator().createDiagram(module));
            }
            List<Aggregate> aggregatesWithStates = this.getAggregatesWithStatesAndTransitions(boundedContext);
            for (Aggregate aggregate : aggregatesWithStates) {
                fsa.generateFile(fileName + "_BC_" + boundedContext.getName() + "_" + aggregate.getName() + "_StateDiagram.puml", (CharSequence)new PlantUMLStateDiagramCreator4Aggregate().createDiagram(aggregate));
            }
            for (Flow flow : this.getFlowsWithStates(boundedContext)) {
                fsa.generateFile(fileName + "_BC_" + boundedContext.getName() + "_" + flow.getName() + "_StateDiagram.puml", (CharSequence)new PlantUMLStateDiagramCreator4Flow().createDiagram(flow));
            }
        }
    }

    private void generateComponentDiagramIfContextMapAvailable(ContextMappingModel model, IFileSystemAccess2 fsa, String fileName) {
        if (model.getMap() != null) {
            fsa.generateFile(fileName + "_ContextMap.puml", (CharSequence)new PlantUMLComponentDiagramCreator().createDiagram(model.getMap()));
        }
    }

    private void checkPreconditions() {
        if (this.contextMappingModel.getMap() == null && this.contextMappingModel.getBoundedContexts().isEmpty() && !this.modelHasSubdomainWithEntities() && this.contextMappingModel.getUserRequirements().isEmpty() && this.contextMappingModel.getStakeholders().isEmpty() && this.contextMappingModel.getValueRegisters().isEmpty()) {
            throw new GeneratorInputException("Your model does not contain a) a Context Map, b) Bounded Contexts or Subdomains with domain objects (Entities, Value Objects, etc.), c) Use Cases or User Stories, or d) Stakeholders or Value Registers. Create at least one of the mentioned model elements.");
        }
    }

    private List<Flow> getFlowsWithStates(BoundedContext bc) {
        LinkedList flows = Lists.newLinkedList();
        if (bc.getApplication() != null) {
            for (Flow flow : bc.getApplication().getFlows()) {
                if (EcoreUtil2.eAllOfType((EObject)flow, StateTransition.class).isEmpty()) continue;
                flows.add(flow);
            }
        }
        return flows;
    }

    private List<Aggregate> getAggregatesWithStatesAndTransitions(BoundedContext bc) {
        LinkedList aggregates = Lists.newLinkedList();
        for (Aggregate aggregate : EcoreUtil2.eAllOfType((EObject)bc, Aggregate.class)) {
            List stateTransitions;
            Optional<Enum> statesEnum = EcoreUtil2.eAllOfType((EObject)aggregate, Enum.class).stream().filter(e -> e.isDefinesAggregateLifecycle()).findFirst();
            if (!statesEnum.isPresent() || (stateTransitions = EcoreUtil2.eAllOfType((EObject)aggregate, StateTransition.class)).isEmpty()) continue;
            aggregates.add(aggregate);
        }
        return aggregates;
    }

    private boolean modelHasSubdomainWithEntities() {
        return this.subdomainResolver.resolveAllSubdomains().stream().filter(subdomain -> !subdomain.getEntities().isEmpty()).findAny().isPresent();
    }
}

