/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.contextMappingDSL;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CoreValue implements Enumerator
{
    UNDEFINED(0, "UNDEFINED", "UNDEFINED"),
    AUTONOMY(1, "AUTONOMY", "AUTONOMY"),
    CARE(2, "CARE", "CARE"),
    CONTROL(3, "CONTROL", "CONTROL"),
    FAIRNESS(4, "FAIRNESS", "FAIRNESS"),
    INCLUSIVENESS(5, "INCLUSIVENESS", "INCLUSIVENESS"),
    INNOVATION(6, "INNOVATION", "INNOVATION"),
    PERFECTION(7, "PERFECTION", "PERFECTION"),
    PRIVACY(8, "PRIVACY", "PRIVACY"),
    RESPECT(9, "RESPECT", "RESPECT"),
    SUSTAINABILITY(10, "SUSTAINABILITY", "SUSTAINABILITY"),
    TRANSPARENCY(11, "TRANSPARENCY", "TRANSPARENCY"),
    TRUST(12, "TRUST", "TRUST");

    public static final int UNDEFINED_VALUE = 0;
    public static final int AUTONOMY_VALUE = 1;
    public static final int CARE_VALUE = 2;
    public static final int CONTROL_VALUE = 3;
    public static final int FAIRNESS_VALUE = 4;
    public static final int INCLUSIVENESS_VALUE = 5;
    public static final int INNOVATION_VALUE = 6;
    public static final int PERFECTION_VALUE = 7;
    public static final int PRIVACY_VALUE = 8;
    public static final int RESPECT_VALUE = 9;
    public static final int SUSTAINABILITY_VALUE = 10;
    public static final int TRANSPARENCY_VALUE = 11;
    public static final int TRUST_VALUE = 12;
    private static final CoreValue[] VALUES_ARRAY;
    public static final List<CoreValue> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static CoreValue get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            CoreValue result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static CoreValue getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            CoreValue result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static CoreValue get(int value) {
        switch (value) {
            case 0: {
                return UNDEFINED;
            }
            case 1: {
                return AUTONOMY;
            }
            case 2: {
                return CARE;
            }
            case 3: {
                return CONTROL;
            }
            case 4: {
                return FAIRNESS;
            }
            case 5: {
                return INCLUSIVENESS;
            }
            case 6: {
                return INNOVATION;
            }
            case 7: {
                return PERFECTION;
            }
            case 8: {
                return PRIVACY;
            }
            case 9: {
                return RESPECT;
            }
            case 10: {
                return SUSTAINABILITY;
            }
            case 11: {
                return TRANSPARENCY;
            }
            case 12: {
                return TRUST;
            }
        }
        return null;
    }

    private CoreValue(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new CoreValue[]{UNDEFINED, AUTONOMY, CARE, CONTROL, FAIRNESS, INCLUSIVENESS, INNOVATION, PERFECTION, PRIVACY, RESPECT, SUSTAINABILITY, TRANSPARENCY, TRUST};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

