/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.cml;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.contextmapper.dsl.cml.CMLImportResolver;
import org.contextmapper.dsl.cml.CMLResource;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingModel;
import org.contextmapper.dsl.contextMappingDSL.Domain;
import org.contextmapper.dsl.contextMappingDSL.Subdomain;

public class CMLModelDomainAndSubdomainResolver {
    private final ContextMappingModel model;
    private final Map<String, Subdomain> declaredSubdomains;
    private final Map<String, Domain> domainsBySubdomainNames;

    public CMLModelDomainAndSubdomainResolver(ContextMappingModel model) {
        this.model = model;
        this.declaredSubdomains = new HashMap<String, Subdomain>();
        this.domainsBySubdomainNames = new HashMap<String, Domain>();
        this.initAllDeclaredSubdomainsIncludingImportedOnes();
    }

    public Set<Subdomain> resolveAllSubdomains() {
        HashMap subdomains4Model = new HashMap();
        for (Domain domain : this.model.getDomains()) {
            domain.getSubdomains().forEach(subdomain -> subdomains4Model.put(subdomain.getName(), this.declaredSubdomains.get(subdomain.getName())));
        }
        for (BoundedContext boundedContext : this.model.getBoundedContexts()) {
            boundedContext.getImplementedDomainParts().forEach(domainPart -> {
                if (domainPart instanceof Domain) {
                    Domain domain = (Domain)domainPart;
                    domain.getSubdomains().forEach(subdomain -> subdomains4Model.put(subdomain.getName(), this.declaredSubdomains.get(subdomain.getName())));
                } else if (domainPart instanceof Subdomain) {
                    Subdomain subdomain2 = (Subdomain)domainPart;
                    subdomains4Model.put(subdomain2.getName(), this.declaredSubdomains.get(subdomain2.getName()));
                }
            });
        }
        return new HashSet<Subdomain>(subdomains4Model.values());
    }

    public Domain resolveDomain4Subdomain(String subdomainName) {
        return this.domainsBySubdomainNames.get(subdomainName);
    }

    private void initAllDeclaredSubdomainsIncludingImportedOnes() {
        this.addDeclaredSubdomains(this.model);
        if (this.model.eResource() != null) {
            for (CMLResource cmlResource : new CMLImportResolver().resolveImportedResources(new CMLResource(this.model.eResource()))) {
                this.addDeclaredSubdomains(cmlResource.getContextMappingModel());
            }
        }
    }

    private void addDeclaredSubdomains(ContextMappingModel model) {
        for (Domain domain : model.getDomains()) {
            domain.getSubdomains().forEach(subdomain -> {
                this.declaredSubdomains.put(subdomain.getName(), (Subdomain)subdomain);
                this.domainsBySubdomainNames.put(subdomain.getName(), domain);
            });
        }
    }
}

