/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator.plantuml;

import org.contextmapper.dsl.generator.plantuml.AssociationLink;
import org.contextmapper.dsl.generator.plantuml.Multiplicity;

public class AssociationInfo {
    private AssociationLink link;
    private Multiplicity multiplicityFirstParticipant;
    private Multiplicity multiplicitySecondParticipant;
    private boolean secondIsNavigableFromFirst;
    private boolean firstIsNavigableFromSecond;
    private String aggregateSource;
    private String aggregateTarget;

    AssociationInfo(AssociationLink link) {
        this.link = link;
        this.multiplicityFirstParticipant = null;
        this.multiplicitySecondParticipant = null;
        this.secondIsNavigableFromFirst = false;
        this.firstIsNavigableFromSecond = false;
    }

    public boolean getIsSecondNavigableFromFirst() {
        return this.secondIsNavigableFromFirst;
    }

    public boolean getIsFirstNavigableFromSecond() {
        return this.firstIsNavigableFromSecond;
    }

    public void setNavigability(String source, String target) {
        if (this.link.getFirstParticipant().equals(source) && this.link.getSecondParticipant().equals(target)) {
            this.secondIsNavigableFromFirst = true;
        }
        if (this.link.getSecondParticipant().equals(source) && this.link.getFirstParticipant().equals(target)) {
            this.firstIsNavigableFromSecond = true;
        }
    }

    public Multiplicity getMultiplicityFirstParticipant() {
        return this.multiplicityFirstParticipant;
    }

    public Multiplicity getMultiplicitySecondParticipant() {
        return this.multiplicitySecondParticipant;
    }

    public void setMultiplicity(String participant, Multiplicity multiplicity) {
        if (this.link.isSelfReference()) {
            return;
        }
        if (participant.equals(this.link.getFirstParticipant())) {
            this.multiplicityFirstParticipant = multiplicity.clone();
        } else {
            this.multiplicitySecondParticipant = multiplicity.clone();
        }
    }

    public Multiplicity getMultiplicity(String participant) {
        if (participant.equals(this.link.getFirstParticipant())) {
            return this.multiplicityFirstParticipant;
        }
        return this.multiplicitySecondParticipant;
    }

    public String getAggregateSource() {
        return this.aggregateSource;
    }

    public String getAggregateTarget() {
        return this.aggregateTarget;
    }

    public void setAggregateSource(String aggregateSource) {
        this.aggregateSource = aggregateSource;
    }

    public void setAggregateTarget(String aggregateTarget) {
        this.aggregateTarget = aggregateTarget;
    }
}

