/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.contextMappingDSL;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Volatility implements Enumerator
{
    UNDEFINED(0, "UNDEFINED", "UNDEFINED"),
    NORMAL(1, "NORMAL", "NORMAL"),
    RARELY(2, "RARELY", "RARELY"),
    OFTEN(3, "OFTEN", "OFTEN");

    public static final int UNDEFINED_VALUE = 0;
    public static final int NORMAL_VALUE = 1;
    public static final int RARELY_VALUE = 2;
    public static final int OFTEN_VALUE = 3;
    private static final Volatility[] VALUES_ARRAY;
    public static final List<Volatility> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static Volatility get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            Volatility result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static Volatility getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            Volatility result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static Volatility get(int value) {
        switch (value) {
            case 0: {
                return UNDEFINED;
            }
            case 1: {
                return NORMAL;
            }
            case 2: {
                return RARELY;
            }
            case 3: {
                return OFTEN;
            }
        }
        return null;
    }

    private Volatility(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new Volatility[]{UNDEFINED, NORMAL, RARELY, OFTEN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

