/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.archunit.conditions;

import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvent;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import java.util.List;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.SculptorModule;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.jmolecules.ddd.annotation.Module;

public class ModeledAsModuleInContext
extends ArchCondition<JavaClass> {
    private final BoundedContext cmlContext;

    private ModeledAsModuleInContext(String description, BoundedContext cmlContext) {
        super(description, new Object[0]);
        this.cmlContext = cmlContext;
    }

    public void check(JavaClass javaClass, ConditionEvents events) {
        Module moduleAnnotation = (Module)javaClass.getAnnotationOfType(Module.class);
        List modules = EcoreUtil2.eAllOfType((EObject)this.cmlContext, SculptorModule.class);
        events.add((ConditionEvent)new SimpleConditionEvent((Object)moduleAnnotation, modules.stream().anyMatch(a -> a.getName().equals(moduleAnnotation.name())), String.format("The module '%s' is not modeled in CML.", moduleAnnotation.name())));
    }

    public static ModeledAsModuleInContext beModeledAsModulesInCML(BoundedContext cmlContext) {
        return new ModeledAsModuleInContext("be modeled as module in CML.", cmlContext);
    }
}

