/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.archunit.conditions;

import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaPackage;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvent;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.stream.Collectors;
import org.contextmapper.archunit.annotations.TacticDDDAnnotationSet;
import org.contextmapper.dsl.contextMappingDSL.Aggregate;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.tactic.dsl.tacticdsl.DomainEvent;
import org.contextmapper.tactic.dsl.tacticdsl.DomainObject;
import org.contextmapper.tactic.dsl.tacticdsl.Entity;
import org.contextmapper.tactic.dsl.tacticdsl.ValueObject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

public class AdhereToCmlAggregateStructure
extends ArchCondition<JavaPackage> {
    private final BoundedContext cmlContext;
    private final TacticDDDAnnotationSet tacticDDDAnnotationTypes;

    private AdhereToCmlAggregateStructure(String description, BoundedContext cmlContext, TacticDDDAnnotationSet tacticDDDAnnotationTypes) {
        super(description, new Object[0]);
        this.cmlContext = cmlContext;
        this.tacticDDDAnnotationTypes = tacticDDDAnnotationTypes;
    }

    public void check(JavaPackage javaPackage, ConditionEvents events) {
        Optional<JavaClass> aggregateRootClass = this.findAggregateRootClass(javaPackage, events);
        if (!aggregateRootClass.isPresent()) {
            return;
        }
        Optional<Aggregate> cmlAggregate = this.findCmlAggregate(javaPackage, events, aggregateRootClass);
        if (!cmlAggregate.isPresent()) {
            return;
        }
        this.checkEntities(cmlAggregate.get(), javaPackage, events);
        this.checkValueObjects(cmlAggregate.get(), javaPackage, events);
        this.checkDomainEvents(cmlAggregate.get(), javaPackage, events);
    }

    private void checkEntities(Aggregate cmlAggregate, JavaPackage javaPackage, ConditionEvents events) {
        this.checkDomainObject(cmlAggregate, javaPackage, events, this.tacticDDDAnnotationTypes.entityAnnotation(), Entity.class);
    }

    private void checkValueObjects(Aggregate cmlAggregate, JavaPackage javaPackage, ConditionEvents events) {
        this.checkDomainObject(cmlAggregate, javaPackage, events, this.tacticDDDAnnotationTypes.valueObjectAnnotation(), ValueObject.class);
    }

    private void checkDomainEvents(Aggregate cmlAggregate, JavaPackage javaPackage, ConditionEvents events) {
        this.checkDomainObject(cmlAggregate, javaPackage, events, this.tacticDDDAnnotationTypes.domainEventAnnotation(), DomainEvent.class);
    }

    private void checkDomainObject(Aggregate cmlAggregate, JavaPackage javaPackage, ConditionEvents events, Class<? extends Annotation> annotation, Class<? extends DomainObject> cmlType) {
        for (JavaClass domainObjectClass : javaPackage.getClasses().stream().filter(c -> c.isAnnotatedWith(annotation)).collect(Collectors.toSet())) {
            Optional<DomainObject> cmlObject = EcoreUtil2.eAllOfType((EObject)cmlAggregate, cmlType).stream().filter(domainObject -> domainObject.getName().equals(domainObjectClass.getSimpleName())).findAny();
            events.add((ConditionEvent)new SimpleConditionEvent((Object)domainObjectClass, cmlObject.isPresent(), String.format("The Aggregate '%s' does not contain a " + cmlType.getSimpleName() + " '%s' in CML.", cmlAggregate.getName(), domainObjectClass.getSimpleName())));
        }
    }

    private Optional<Aggregate> findCmlAggregate(JavaPackage javaPackage, ConditionEvents events, Optional<JavaClass> aggregateRootClass) {
        Optional<Aggregate> cmlAggregate = EcoreUtil2.eAllOfType((EObject)this.cmlContext, Aggregate.class).stream().filter(a -> a.getName().equals(((JavaClass)aggregateRootClass.get()).getSimpleName())).findAny();
        events.add((ConditionEvent)new SimpleConditionEvent((Object)javaPackage, cmlAggregate.isPresent(), String.format("The aggregate '%s' is not modeled in CML.", aggregateRootClass.get().getSimpleName())));
        return cmlAggregate;
    }

    private Optional<JavaClass> findAggregateRootClass(JavaPackage javaPackage, ConditionEvents events) {
        Optional<JavaClass> aggregateRootClass = javaPackage.getClasses().stream().filter(c -> c.isAnnotatedWith(this.tacticDDDAnnotationTypes.aggregateRootAnnotation())).findAny();
        events.add((ConditionEvent)new SimpleConditionEvent((Object)javaPackage, aggregateRootClass.isPresent(), String.format("The aggregate root class for package '%s' cannot be found.", javaPackage.getName())));
        return aggregateRootClass;
    }

    public static AdhereToCmlAggregateStructure adhereToCmlAggregateStructure(BoundedContext cmlContext, TacticDDDAnnotationSet tacticDDDAnnotationTypes) {
        return new AdhereToCmlAggregateStructure("adhere to CML Aggregate structure.", cmlContext, tacticDDDAnnotationTypes);
    }
}

