/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.archunit;

import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.core.importer.ClassFileImporter;
import com.tngtech.archunit.core.importer.ImportOption;
import org.contextmapper.archunit.ContextMapperJMoleculesArchRules;
import org.contextmapper.archunit.cml.BoundedContextResolver;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class AbstractTacticArchUnitTest {
    protected BoundedContext context;
    protected JavaClasses classes;

    protected abstract String getBoundedContextName();

    protected abstract String getCMLFilePath();

    protected abstract String getJavaPackageName2Test();

    @BeforeEach
    protected void setup() {
        this.context = new BoundedContextResolver().resolveBoundedContextFromModel(this.getCMLFilePath(), this.getBoundedContextName());
        this.classes = this.importClasses();
    }

    protected JavaClasses importClasses() {
        return new ClassFileImporter().withImportOption((ImportOption)ImportOption.Predefined.DO_NOT_INCLUDE_TESTS).importPackages(new String[]{this.getJavaPackageName2Test()});
    }

    @Test
    void aggregatesShouldBeModeledInCML() {
        ContextMapperJMoleculesArchRules.aggregateClassesShouldBeModeledInCml(this.context).allowEmptyShould(true).check(this.classes);
    }

    @Test
    void aggregatesShouldAdhereToCmlAggregateStructure() {
        ContextMapperJMoleculesArchRules.aggregatesShouldAdhereToCmlStructure(this.context).allowEmptyShould(true).check(this.classes);
    }

    @Test
    void modulesShouldBeModeledInCML() {
        ContextMapperJMoleculesArchRules.modulePackagesShouldBeModeledInCml(this.context).allowEmptyShould(true).check(this.classes);
    }

    @Test
    void entitiesShouldBeModeledInCML() {
        ContextMapperJMoleculesArchRules.entityClassesShouldBeModeledInCml(this.context).allowEmptyShould(true).check(this.classes);
    }

    @Test
    void valueObjectsShouldBeModeledInCML() {
        ContextMapperJMoleculesArchRules.valueObjectClassesShouldBeModeledInCml(this.context).allowEmptyShould(true).check(this.classes);
    }

    @Test
    void domainEventsShouldBeModeledInCML() {
        ContextMapperJMoleculesArchRules.domainEventClassesShouldBeModeledInCml(this.context).allowEmptyShould(true).check(this.classes);
    }

    @Test
    void servicesShouldBeModeledInCML() {
        ContextMapperJMoleculesArchRules.serviceClassesShouldBeModeledInCml(this.context).allowEmptyShould(true).check(this.classes);
    }

    @Test
    void repositoriesShouldBeModeledInCML() {
        ContextMapperJMoleculesArchRules.repositoryClassesShouldBeModeledInCml(this.context).allowEmptyShould(true).check(this.classes);
    }

    @Test
    void entitiesShouldAdhereToCmlStructure() {
        ContextMapperJMoleculesArchRules.entitiesShouldAdhereToCmlEntityStructure(this.context).allowEmptyShould(true).check(this.classes);
    }

    @Test
    void valueObjectsShouldAdhereToCmlStructure() {
        ContextMapperJMoleculesArchRules.valueObjectsShouldAdhereToCmlValueObjectStructure(this.context).allowEmptyShould(true).check(this.classes);
    }

    @Test
    void domainEventsShouldAdhereToCmlStructure() {
        ContextMapperJMoleculesArchRules.domainEventsShouldAdhereToCmlDomainEventStructure(this.context).allowEmptyShould(true).check(this.classes);
    }
}

