/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.signature;

import com.google.crypto.tink.subtle.Ed25519Sign;
import com.trilead.ssh2.crypto.keys.Ed25519KeyFactory;
import com.trilead.ssh2.crypto.keys.Ed25519PrivateKey;
import com.trilead.ssh2.crypto.keys.Ed25519PublicKey;
import com.trilead.ssh2.log.Logger;
import com.trilead.ssh2.packets.TypesReader;
import com.trilead.ssh2.packets.TypesWriter;
import com.trilead.ssh2.signature.SSHSignature;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;

public class Ed25519Verify
implements SSHSignature {
    private static final Logger log = Logger.getLogger(Ed25519Verify.class);
    public static final String ED25519_ID = "ssh-ed25519";
    private static final int ED25519_PK_SIZE_BYTES = 32;
    private static final int ED25519_SIG_SIZE_BYTES = 64;

    private Ed25519Verify() {
    }

    public static Ed25519Verify get() {
        return InstanceHolder.sInstance;
    }

    @Override
    public byte[] encodePublicKey(PublicKey publicKey) throws IOException {
        Ed25519PublicKey ed25519PublicKey = Ed25519Verify.convertPublicKey(publicKey);
        TypesWriter tw = new TypesWriter();
        tw.writeString(ED25519_ID);
        byte[] encoded = ed25519PublicKey.getAbyte();
        tw.writeString(encoded, 0, encoded.length);
        return tw.getBytes();
    }

    @Override
    public PublicKey decodePublicKey(byte[] encoded) throws IOException {
        TypesReader tr = new TypesReader(encoded);
        String key_format = tr.readString();
        if (!key_format.equals(ED25519_ID)) {
            throw new IOException("This is not an Ed25519 key");
        }
        byte[] keyBytes = tr.readByteString();
        if (tr.remain() != 0) {
            throw new IOException("Padding in Ed25519 public key! " + tr.remain() + " bytes left.");
        }
        if (keyBytes.length != 32) {
            throw new IOException("Ed25519 was not of correct length: " + keyBytes.length + " vs 32");
        }
        return new Ed25519PublicKey(keyBytes);
    }

    @Override
    public byte[] generateSignature(byte[] msg, PrivateKey privateKey, SecureRandom secureRandom) throws IOException {
        Ed25519PrivateKey ed25519PrivateKey = Ed25519Verify.convertPrivateKey(privateKey);
        try {
            return Ed25519Verify.encodeSSHEd25519Signature(new Ed25519Sign(ed25519PrivateKey.getSeed()).sign(msg));
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }

    public static Ed25519PublicKey convertPublicKey(PublicKey publicKey) throws IOException {
        Ed25519KeyFactory kf = new Ed25519KeyFactory();
        try {
            return (Ed25519PublicKey)kf.engineTranslateKey(publicKey);
        }
        catch (InvalidKeyException e) {
            throw new IOException(e);
        }
    }

    public static Ed25519PrivateKey convertPrivateKey(PrivateKey privateKey) throws IOException {
        Ed25519KeyFactory kf = new Ed25519KeyFactory();
        try {
            return (Ed25519PrivateKey)kf.engineTranslateKey(privateKey);
        }
        catch (InvalidKeyException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean verifySignature(byte[] message, byte[] sshSig, PublicKey publicKey) throws IOException {
        Ed25519PublicKey ed25519PublicKey = Ed25519Verify.convertPublicKey(publicKey);
        byte[] javaSig = Ed25519Verify.decodeSSHEd25519Signature(sshSig);
        try {
            new com.google.crypto.tink.subtle.Ed25519Verify(ed25519PublicKey.getAbyte()).verify(javaSig, message);
            return true;
        }
        catch (GeneralSecurityException e) {
            return false;
        }
    }

    private static byte[] encodeSSHEd25519Signature(byte[] sig) {
        TypesWriter tw = new TypesWriter();
        tw.writeString(ED25519_ID);
        tw.writeString(sig, 0, sig.length);
        return tw.getBytes();
    }

    private static byte[] decodeSSHEd25519Signature(byte[] sig) throws IOException {
        TypesReader tr = new TypesReader(sig);
        String sig_format = tr.readString();
        if (!sig_format.equals(ED25519_ID)) {
            throw new IOException("Peer sent wrong signature format");
        }
        byte[] rsArray = tr.readByteString();
        if (tr.remain() != 0) {
            throw new IOException("Padding in Ed25519 signature!");
        }
        if (rsArray.length > 64) {
            throw new IOException("Ed25519 signature was " + rsArray.length + " bytes (32 expected)");
        }
        return rsArray;
    }

    @Override
    public String getKeyFormat() {
        return ED25519_ID;
    }

    private static class InstanceHolder {
        private static final Ed25519Verify sInstance = new Ed25519Verify();

        private InstanceHolder() {
        }
    }
}

