/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.sdk.workflow.executor.task;

import com.netflix.conductor.common.metadata.tasks.Task;
import com.netflix.conductor.common.metadata.tasks.TaskResult;

public class TaskContext {
    public static final ThreadLocal<TaskContext> TASK_CONTEXT_INHERITABLE_THREAD_LOCAL = InheritableThreadLocal.withInitial(() -> null);
    private final Task task;
    private final TaskResult taskResult;

    public TaskContext(Task task, TaskResult taskResult) {
        this.task = task;
        this.taskResult = taskResult;
    }

    public static TaskContext get() {
        return TASK_CONTEXT_INHERITABLE_THREAD_LOCAL.get();
    }

    public static TaskContext set(Task task) {
        TaskResult result = new TaskResult(task);
        TaskContext context = new TaskContext(task, result);
        TASK_CONTEXT_INHERITABLE_THREAD_LOCAL.set(context);
        return context;
    }

    public String getWorkflowInstanceId() {
        return this.task.getWorkflowInstanceId();
    }

    public String getTaskId() {
        return this.task.getTaskId();
    }

    public int getRetryCount() {
        return this.task.getRetryCount();
    }

    public int getPollCount() {
        return this.task.getPollCount();
    }

    public long getCallbackAfterSeconds() {
        return this.task.getCallbackAfterSeconds();
    }

    public void addLog(String log) {
        this.taskResult.log(log);
    }

    public Task getTask() {
        return this.task;
    }

    public TaskResult getTaskResult() {
        return this.taskResult;
    }

    public void setCallbackAfter(int seconds) {
        this.taskResult.setCallbackAfterSeconds((long)seconds);
    }
}

