/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.sdk.workflow.executor.task;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.conductor.client.worker.Worker;
import com.netflix.conductor.common.metadata.tasks.Task;
import com.netflix.conductor.common.metadata.tasks.TaskDef;
import com.netflix.conductor.common.metadata.tasks.TaskResult;
import com.netflix.conductor.sdk.workflow.def.tasks.DynamicForkInput;
import com.netflix.conductor.sdk.workflow.task.InputParam;
import com.netflix.conductor.sdk.workflow.utils.ObjectMapperProvider;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.function.Function;

public class DynamicForkWorker
implements Worker {
    private final int pollingInterval;
    private final Function<Object, DynamicForkInput> workerMethod;
    private final String name;
    private ObjectMapper objectMapper = new ObjectMapperProvider().getObjectMapper();

    public DynamicForkWorker(String name, Function<Object, DynamicForkInput> workerMethod, int pollingInterval) {
        this.name = name;
        this.workerMethod = workerMethod;
        this.pollingInterval = pollingInterval;
    }

    public String getTaskDefName() {
        return this.name;
    }

    public TaskResult execute(Task task) {
        TaskResult result = new TaskResult(task);
        try {
            Object parameter = this.getInvocationParameters(this.workerMethod, task);
            DynamicForkInput output = this.workerMethod.apply(parameter);
            result.getOutputData().put("forkedTasks", output.getTasks());
            result.getOutputData().put("forkedTasksInputs", output.getInputs());
            result.setStatus(TaskResult.Status.COMPLETED);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public int getPollingInterval() {
        return this.pollingInterval;
    }

    private Object getInvocationParameters(Function<?, DynamicForkInput> function, Task task) {
        InputParam annotation = null;
        Class<?> parameterType = null;
        for (Method method : function.getClass().getDeclaredMethods()) {
            if (!method.getReturnType().equals(DynamicForkInput.class)) continue;
            annotation = method.getParameters()[0].getAnnotation(InputParam.class);
            parameterType = method.getParameters()[0].getType();
        }
        if (parameterType.equals(Task.class)) {
            return task;
        }
        if (parameterType.equals(Map.class)) {
            return task.getInputData();
        }
        if (annotation != null) {
            String name = annotation.value();
            Object value = task.getInputData().get(name);
            return this.objectMapper.convertValue(value, parameterType);
        }
        return this.objectMapper.convertValue((Object)task.getInputData(), (Class)parameterType);
    }

    public static void main(String[] args) {
        Function<TaskDef, DynamicForkInput> fn = new Function<TaskDef, DynamicForkInput>(){

            @Override
            public DynamicForkInput apply(@InputParam(value="a") TaskDef s) {
                return null;
            }
        };
        for (Method method : fn.getClass().getDeclaredMethods()) {
            if (!method.getReturnType().equals(DynamicForkInput.class)) continue;
            System.out.println("\n\n-->method: " + method + ", input: " + method.getParameters()[0].getType());
            System.out.println("I take input as " + method.getParameters()[0].getType());
            InputParam annotation = method.getParameters()[0].getAnnotation(InputParam.class);
            System.out.println("I have annotation " + annotation);
        }
    }
}

