/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.sdk.workflow.def.tasks;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.netflix.conductor.common.metadata.tasks.TaskType;
import com.netflix.conductor.common.metadata.workflow.WorkflowTask;
import com.netflix.conductor.sdk.workflow.utils.InputOutputGetter;
import com.netflix.conductor.sdk.workflow.utils.MapBuilder;
import com.netflix.conductor.sdk.workflow.utils.ObjectMapperProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Task<T> {
    private String name;
    private String description;
    private String taskReferenceName;
    private boolean optional;
    private int startDelay;
    private TaskType type;
    private Map<String, Object> input = new HashMap<String, Object>();
    protected final ObjectMapper om = new ObjectMapperProvider().getObjectMapper();
    public final InputOutputGetter taskInput;
    public final InputOutputGetter taskOutput;

    public Task(String taskReferenceName, TaskType type) {
        if (Strings.isNullOrEmpty((String)taskReferenceName)) {
            throw new AssertionError((Object)"taskReferenceName cannot be null");
        }
        if (type == null) {
            throw new AssertionError((Object)"type cannot be null");
        }
        this.name = taskReferenceName;
        this.taskReferenceName = taskReferenceName;
        this.type = type;
        this.taskInput = new InputOutputGetter(taskReferenceName, InputOutputGetter.Field.input);
        this.taskOutput = new InputOutputGetter(taskReferenceName, InputOutputGetter.Field.output);
    }

    Task(WorkflowTask workflowTask) {
        this(workflowTask.getTaskReferenceName(), TaskType.valueOf((String)workflowTask.getType()));
        this.input = workflowTask.getInputParameters();
        this.description = workflowTask.getDescription();
        this.name = workflowTask.getName();
    }

    public T name(String name) {
        this.name = name;
        return (T)this;
    }

    public T description(String description) {
        this.description = description;
        return (T)this;
    }

    public T input(String key, boolean value) {
        this.input.put(key, value);
        return (T)this;
    }

    public T input(String key, Object value) {
        this.input.put(key, value);
        return (T)this;
    }

    public T input(String key, char value) {
        this.input.put(key, Character.valueOf(value));
        return (T)this;
    }

    public T input(String key, InputOutputGetter value) {
        this.input.put(key, value.getParent());
        return (T)this;
    }

    public T input(InputOutputGetter value) {
        return this.input("input", value);
    }

    public T input(String key, String value) {
        this.input.put(key, value);
        return (T)this;
    }

    public T input(String key, Number value) {
        this.input.put(key, value);
        return (T)this;
    }

    public T input(String key, Map<String, Object> value) {
        this.input.put(key, value);
        return (T)this;
    }

    public T input(Map<String, Object> map) {
        this.input.putAll(map);
        return (T)this;
    }

    public T input(MapBuilder builder) {
        this.input.putAll(builder.build());
        return (T)this;
    }

    public T input(Object ... keyValues) {
        if (keyValues.length == 1) {
            Object kv = keyValues[0];
            Map objectMap = (Map)this.om.convertValue(kv, Map.class);
            this.input.putAll(objectMap);
            return (T)this;
        }
        if (keyValues.length % 2 == 1) {
            throw new IllegalArgumentException("Not all keys have value specified");
        }
        for (int i = 0; i < keyValues.length; i += 2) {
            String key = keyValues[i].toString();
            Object value = keyValues[i + 1];
            this.input.put(key, value);
        }
        return (T)this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTaskReferenceName() {
        return this.taskReferenceName;
    }

    public void setTaskReferenceName(String taskReferenceName) {
        this.taskReferenceName = taskReferenceName;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public int getStartDelay() {
        return this.startDelay;
    }

    public void setStartDelay(int startDelay) {
        this.startDelay = startDelay;
    }

    public TaskType getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, Object> getInput() {
        return this.input;
    }

    public final List<WorkflowTask> getWorkflowDefTasks() {
        ArrayList<WorkflowTask> workflowTasks = new ArrayList<WorkflowTask>();
        workflowTasks.addAll(this.getParentTasks());
        workflowTasks.add(this.toWorkflowTask());
        workflowTasks.addAll(this.getChildrenTasks());
        return workflowTasks;
    }

    protected final WorkflowTask toWorkflowTask() {
        WorkflowTask workflowTask = new WorkflowTask();
        workflowTask.setName(this.name);
        workflowTask.setTaskReferenceName(this.taskReferenceName);
        workflowTask.setWorkflowTaskType(this.type);
        workflowTask.setDescription(this.description);
        workflowTask.setInputParameters(this.input);
        workflowTask.setStartDelay(this.startDelay);
        workflowTask.setOptional(this.optional);
        this.updateWorkflowTask(workflowTask);
        return workflowTask;
    }

    protected void updateWorkflowTask(WorkflowTask workflowTask) {
    }

    protected List<WorkflowTask> getChildrenTasks() {
        return List.of();
    }

    protected List<WorkflowTask> getParentTasks() {
        return List.of();
    }
}

