/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.sdk.workflow.def.tasks;

import com.netflix.conductor.common.metadata.tasks.TaskType;
import com.netflix.conductor.common.metadata.workflow.WorkflowTask;
import com.netflix.conductor.sdk.workflow.def.tasks.SimpleTask;
import com.netflix.conductor.sdk.workflow.def.tasks.Task;
import com.netflix.conductor.sdk.workflow.def.tasks.TaskRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Switch
extends Task<Switch> {
    public static final String VALUE_PARAM_NAME = "value-param";
    public static final String JAVASCRIPT_NAME = "javascript";
    private String caseExpression;
    private boolean useJavascript;
    private List<Task<?>> defaultTasks = new ArrayList();
    private Map<String, List<Task<?>>> branches = new HashMap();

    public Switch(String taskReferenceName, String caseExpression, boolean useJavascript) {
        super(taskReferenceName, TaskType.SWITCH);
        this.caseExpression = caseExpression;
        this.useJavascript = useJavascript;
    }

    public Switch(String taskReferenceName, String caseExpression) {
        super(taskReferenceName, TaskType.SWITCH);
        this.caseExpression = caseExpression;
        this.useJavascript = false;
    }

    Switch(WorkflowTask workflowTask) {
        super(workflowTask);
        Map decisions = workflowTask.getDecisionCases();
        decisions.entrySet().stream().forEach(branch -> {
            String branchName = (String)branch.getKey();
            List branchWorkflowTasks = (List)branch.getValue();
            ArrayList branchTasks = new ArrayList();
            for (WorkflowTask branchWorkflowTask : branchWorkflowTasks) {
                branchTasks.add(TaskRegistry.getTask(branchWorkflowTask));
            }
            this.branches.put(branchName, branchTasks);
        });
        List defaultCases = workflowTask.getDefaultCase();
        for (WorkflowTask defaultCase : defaultCases) {
            this.defaultTasks.add(TaskRegistry.getTask(defaultCase));
        }
    }

    public Switch defaultCase(Task<?> ... tasks) {
        this.defaultTasks = Arrays.asList(tasks);
        return this;
    }

    public Switch defaultCase(List<Task<?>> defaultTasks) {
        this.defaultTasks = defaultTasks;
        return this;
    }

    public Switch decisionCases(Map<String, List<Task<?>>> branches) {
        this.branches = branches;
        return this;
    }

    public Switch defaultCase(String ... workerTasks) {
        for (String workerTask : workerTasks) {
            this.defaultTasks.add(new SimpleTask(workerTask, workerTask));
        }
        return this;
    }

    public Switch switchCase(String caseValue, Task ... tasks) {
        this.branches.put(caseValue, Arrays.asList(tasks));
        return this;
    }

    public Switch switchCase(String caseValue, String ... workerTasks) {
        ArrayList<SimpleTask> tasks = new ArrayList<SimpleTask>(workerTasks.length);
        boolean i = false;
        for (String workerTask : workerTasks) {
            tasks.add(new SimpleTask(workerTask, workerTask));
        }
        this.branches.put(caseValue, tasks);
        return this;
    }

    public List<Task<?>> getDefaultTasks() {
        return this.defaultTasks;
    }

    public Map<String, List<Task<?>>> getBranches() {
        return this.branches;
    }

    @Override
    public void updateWorkflowTask(WorkflowTask workflowTask) {
        if (this.useJavascript) {
            workflowTask.setEvaluatorType(JAVASCRIPT_NAME);
            workflowTask.setExpression(this.caseExpression);
        } else {
            workflowTask.setEvaluatorType(VALUE_PARAM_NAME);
            workflowTask.getInputParameters().put("switchCaseValue", this.caseExpression);
            workflowTask.setExpression("switchCaseValue");
        }
        HashMap decisionCases = new HashMap();
        this.branches.entrySet().forEach(entry -> {
            String decisionCase = (String)entry.getKey();
            List decisionTasks = (List)entry.getValue();
            ArrayList<WorkflowTask> decionTaskDefs = new ArrayList<WorkflowTask>(decisionTasks.size());
            for (Task decisionTask : decisionTasks) {
                decionTaskDefs.addAll(decisionTask.getWorkflowDefTasks());
            }
            decisionCases.put(decisionCase, decionTaskDefs);
        });
        workflowTask.setDecisionCases(decisionCases);
        ArrayList<WorkflowTask> defaultCaseTaskDefs = new ArrayList<WorkflowTask>(this.defaultTasks.size());
        for (Task<?> defaultTask : this.defaultTasks) {
            defaultCaseTaskDefs.addAll(defaultTask.getWorkflowDefTasks());
        }
        workflowTask.setDefaultCase(defaultCaseTaskDefs);
    }
}

