/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.sdk.workflow.def.tasks;

import com.netflix.conductor.common.metadata.tasks.TaskType;
import com.netflix.conductor.common.metadata.workflow.SubWorkflowParams;
import com.netflix.conductor.common.metadata.workflow.WorkflowTask;
import com.netflix.conductor.sdk.workflow.def.ConductorWorkflow;
import com.netflix.conductor.sdk.workflow.def.tasks.Task;

public class SubWorkflow
extends Task<SubWorkflow> {
    private ConductorWorkflow conductorWorkflow;
    private String workflowName;
    private Integer workflowVersion;

    public SubWorkflow(String taskReferenceName, String workflowName, Integer workflowVersion) {
        super(taskReferenceName, TaskType.SUB_WORKFLOW);
        this.workflowName = workflowName;
        this.workflowVersion = workflowVersion;
    }

    public SubWorkflow(String taskReferenceName, ConductorWorkflow conductorWorkflow) {
        super(taskReferenceName, TaskType.SUB_WORKFLOW);
        this.conductorWorkflow = conductorWorkflow;
    }

    SubWorkflow(WorkflowTask workflowTask) {
        super(workflowTask);
        SubWorkflowParams subworkflowParam = workflowTask.getSubWorkflowParam();
        this.workflowName = subworkflowParam.getName();
        this.workflowVersion = subworkflowParam.getVersion();
        if (subworkflowParam.getWorkflowDef() != null) {
            this.conductorWorkflow = ConductorWorkflow.fromWorkflowDef(subworkflowParam.getWorkflowDef());
        }
    }

    public ConductorWorkflow getConductorWorkflow() {
        return this.conductorWorkflow;
    }

    public String getWorkflowName() {
        return this.workflowName;
    }

    public int getWorkflowVersion() {
        return this.workflowVersion;
    }

    @Override
    protected void updateWorkflowTask(WorkflowTask workflowTask) {
        SubWorkflowParams subWorkflowParam = new SubWorkflowParams();
        if (this.conductorWorkflow != null) {
            subWorkflowParam.setWorkflowDef(this.conductorWorkflow.toWorkflowDef());
        } else {
            subWorkflowParam.setName(this.workflowName);
            subWorkflowParam.setVersion(this.workflowVersion);
        }
        workflowTask.setSubWorkflowParam(subWorkflowParam);
    }
}

