/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.sdk.workflow.def.tasks;

import com.netflix.conductor.common.metadata.tasks.TaskType;
import com.netflix.conductor.common.metadata.workflow.WorkflowTask;
import com.netflix.conductor.sdk.workflow.def.tasks.Join;
import com.netflix.conductor.sdk.workflow.def.tasks.SimpleTask;
import com.netflix.conductor.sdk.workflow.def.tasks.Task;
import java.util.ArrayList;
import java.util.List;

public class DynamicFork
extends Task<DynamicFork> {
    public static final String FORK_TASK_PARAM = "forkedTasks";
    public static final String FORK_TASK_INPUT_PARAM = "forkedTasksInputs";
    private String forkTasksParameter;
    private String forkTasksInputsParameter;
    private Join join;
    private SimpleTask forkPrepareTask;

    public DynamicFork(String taskReferenceName, String forkTasksParameter, String forkTasksInputsParameter) {
        super(taskReferenceName, TaskType.FORK_JOIN_DYNAMIC);
        this.join = new Join(taskReferenceName + "_join", new String[0]);
        this.forkTasksParameter = forkTasksParameter;
        this.forkTasksInputsParameter = forkTasksInputsParameter;
        super.input(FORK_TASK_PARAM, forkTasksParameter);
        super.input(FORK_TASK_INPUT_PARAM, forkTasksInputsParameter);
    }

    public DynamicFork(String taskReferenceName, SimpleTask forkPrepareTask) {
        super(taskReferenceName, TaskType.FORK_JOIN_DYNAMIC);
        this.forkPrepareTask = forkPrepareTask;
        this.join = new Join(taskReferenceName + "_join", new String[0]);
        this.forkTasksParameter = forkPrepareTask.taskOutput.get(FORK_TASK_PARAM);
        this.forkTasksInputsParameter = forkPrepareTask.taskOutput.get(FORK_TASK_INPUT_PARAM);
        super.input(FORK_TASK_PARAM, this.forkTasksParameter);
        super.input(FORK_TASK_INPUT_PARAM, this.forkTasksInputsParameter);
    }

    DynamicFork(WorkflowTask workflowTask) {
        super(workflowTask);
        String nameOfParamForForkTask = workflowTask.getDynamicForkTasksParam();
        String nameOfParamForForkTaskInput = workflowTask.getDynamicForkTasksInputParamName();
        this.forkTasksParameter = (String)workflowTask.getInputParameters().get(nameOfParamForForkTask);
        this.forkTasksInputsParameter = (String)workflowTask.getInputParameters().get(nameOfParamForForkTaskInput);
    }

    public Join getJoin() {
        return this.join;
    }

    public String getForkTasksParameter() {
        return this.forkTasksParameter;
    }

    public String getForkTasksInputsParameter() {
        return this.forkTasksInputsParameter;
    }

    @Override
    public void updateWorkflowTask(WorkflowTask task) {
        task.setDynamicForkTasksParam(FORK_TASK_PARAM);
        task.setDynamicForkTasksInputParamName(FORK_TASK_INPUT_PARAM);
    }

    @Override
    protected List<WorkflowTask> getChildrenTasks() {
        ArrayList<WorkflowTask> tasks = new ArrayList<WorkflowTask>();
        tasks.addAll(this.join.getWorkflowDefTasks());
        return tasks;
    }

    @Override
    protected List<WorkflowTask> getParentTasks() {
        if (this.forkPrepareTask != null) {
            return List.of(this.forkPrepareTask.toWorkflowTask());
        }
        return List.of();
    }
}

