/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.sdk.workflow.def.tasks;

import com.netflix.conductor.common.metadata.tasks.TaskType;
import com.netflix.conductor.common.metadata.workflow.WorkflowTask;
import com.netflix.conductor.sdk.workflow.def.tasks.Task;
import com.netflix.conductor.sdk.workflow.def.tasks.TaskRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DoWhile
extends Task<DoWhile> {
    private String loopCondition;
    private List<Task<?>> loopTasks = new ArrayList();

    public DoWhile(String taskReferenceName, String condition, Task<?> ... tasks) {
        super(taskReferenceName, TaskType.DO_WHILE);
        Collections.addAll(this.loopTasks, tasks);
        this.loopCondition = condition;
    }

    public DoWhile(String taskReferenceName, int loopCount, Task<?> ... tasks) {
        super(taskReferenceName, TaskType.DO_WHILE);
        Collections.addAll(this.loopTasks, tasks);
        this.loopCondition = this.getForLoopCondition(loopCount);
    }

    DoWhile(WorkflowTask workflowTask) {
        super(workflowTask);
        this.loopCondition = workflowTask.getLoopCondition();
        for (WorkflowTask task : workflowTask.getLoopOver()) {
            Task<?> loopTask = TaskRegistry.getTask(task);
            this.loopTasks.add(loopTask);
        }
    }

    public DoWhile loopOver(Task<?> ... tasks) {
        for (Task<?> task : tasks) {
            this.loopTasks.add(task);
        }
        return this;
    }

    private String getForLoopCondition(int loopCount) {
        return "if ( $." + this.getTaskReferenceName() + "['iteration'] < " + loopCount + ") { true; } else { false; }";
    }

    public String getLoopCondition() {
        return this.loopCondition;
    }

    public List<? extends Task> getLoopTasks() {
        return this.loopTasks;
    }

    @Override
    public void updateWorkflowTask(WorkflowTask workflowTask) {
        workflowTask.setLoopCondition(this.loopCondition);
        ArrayList<WorkflowTask> loopWorkflowTasks = new ArrayList<WorkflowTask>();
        for (Task<?> task : this.loopTasks) {
            loopWorkflowTasks.addAll(task.getWorkflowDefTasks());
        }
        workflowTask.setLoopOver(loopWorkflowTasks);
    }
}

