/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.sdk.workflow.def;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.conductor.common.metadata.workflow.WorkflowDef;
import com.netflix.conductor.common.metadata.workflow.WorkflowTask;
import com.netflix.conductor.sdk.workflow.def.ConductorWorkflow;
import com.netflix.conductor.sdk.workflow.def.ValidationError;
import com.netflix.conductor.sdk.workflow.def.tasks.Task;
import com.netflix.conductor.sdk.workflow.executor.WorkflowExecutor;
import com.netflix.conductor.sdk.workflow.utils.InputOutputGetter;
import com.netflix.conductor.sdk.workflow.utils.MapBuilder;
import com.netflix.conductor.sdk.workflow.utils.ObjectMapperProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class WorkflowBuilder<T> {
    private String name;
    private String description;
    private int version;
    private String failureWorkflow;
    private String ownerEmail;
    private WorkflowDef.TimeoutPolicy timeoutPolicy;
    private long timeoutSeconds;
    private boolean restartable = true;
    private T defaultInput;
    private Map<String, Object> output = new HashMap<String, Object>();
    private Map<String, Object> state;
    protected List<Task<?>> tasks = new ArrayList();
    private WorkflowExecutor workflowExecutor;
    public final InputOutputGetter input = new InputOutputGetter("workflow", InputOutputGetter.Field.input);
    private final ObjectMapper objectMapper = new ObjectMapperProvider().getObjectMapper();

    public WorkflowBuilder(WorkflowExecutor workflowExecutor) {
        this.workflowExecutor = workflowExecutor;
        this.tasks = new ArrayList();
    }

    public WorkflowBuilder<T> name(String name) {
        this.name = name;
        return this;
    }

    public WorkflowBuilder<T> version(int version) {
        this.version = version;
        return this;
    }

    public WorkflowBuilder<T> description(String description) {
        this.description = description;
        return this;
    }

    public WorkflowBuilder<T> failureWorkflow(String failureWorkflow) {
        this.failureWorkflow = failureWorkflow;
        return this;
    }

    public WorkflowBuilder<T> ownerEmail(String ownerEmail) {
        this.ownerEmail = ownerEmail;
        return this;
    }

    public WorkflowBuilder<T> timeoutPolicy(WorkflowDef.TimeoutPolicy timeoutPolicy, long timeoutSeconds) {
        this.timeoutPolicy = timeoutPolicy;
        this.timeoutSeconds = timeoutSeconds;
        return this;
    }

    public WorkflowBuilder<T> add(Task<?> ... tasks) {
        Collections.addAll(this.tasks, tasks);
        return this;
    }

    public WorkflowBuilder<T> defaultInput(T defaultInput) {
        this.defaultInput = defaultInput;
        return this;
    }

    public WorkflowBuilder<T> restartable(boolean restartable) {
        this.restartable = restartable;
        return this;
    }

    public WorkflowBuilder<T> variables(Object variables) {
        try {
            this.state = (Map)this.objectMapper.convertValue(variables, Map.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Workflow Variables cannot be converted to Map.  Supplied: " + variables.getClass().getName());
        }
        return this;
    }

    public WorkflowBuilder<T> output(String key, boolean value) {
        this.output.put(key, value);
        return this;
    }

    public WorkflowBuilder<T> output(String key, String value) {
        this.output.put(key, value);
        return this;
    }

    public WorkflowBuilder<T> output(String key, Number value) {
        this.output.put(key, value);
        return this;
    }

    public WorkflowBuilder<T> output(String key, Object value) {
        this.output.put(key, value);
        return this;
    }

    public WorkflowBuilder<T> output(MapBuilder mapBuilder) {
        this.output.putAll(mapBuilder.build());
        return this;
    }

    public ConductorWorkflow<T> build() throws ValidationError {
        this.validate();
        ConductorWorkflow<T> workflow = new ConductorWorkflow<T>(this.workflowExecutor);
        if (this.description != null) {
            workflow.setDescription(this.description);
        }
        workflow.setName(this.name);
        workflow.setVersion(this.version);
        workflow.setDescription(this.description);
        workflow.setFailureWorkflow(this.failureWorkflow);
        workflow.setOwnerEmail(this.ownerEmail);
        workflow.setTimeoutPolicy(this.timeoutPolicy);
        workflow.setTimeoutSeconds(this.timeoutSeconds);
        workflow.setRestartable(this.restartable);
        workflow.setDefaultInput(this.defaultInput);
        workflow.setWorkflowOutput(this.output);
        workflow.setVariables(this.state);
        for (Task<?> task : this.tasks) {
            workflow.add(task);
        }
        return workflow;
    }

    private void validate() throws ValidationError {
        ArrayList allTasks = new ArrayList();
        for (Task<?> task : this.tasks) {
            List<WorkflowTask> workflowDefTasks = task.getWorkflowDefTasks();
            for (WorkflowTask workflowDefTask : workflowDefTasks) {
                allTasks.addAll(workflowDefTask.collectTasks());
            }
        }
        HashMap<String, WorkflowTask> taskMap = new HashMap<String, WorkflowTask>();
        HashSet<String> duplicateTasks = new HashSet<String>();
        for (WorkflowTask task : allTasks) {
            if (taskMap.containsKey(task.getTaskReferenceName())) {
                duplicateTasks.add(task.getTaskReferenceName());
                continue;
            }
            taskMap.put(task.getTaskReferenceName(), task);
        }
        if (!duplicateTasks.isEmpty()) {
            throw new ValidationError("Task Reference Names MUST be unique across all the tasks in the workkflow.  Please update/change reference names to be unique for the following tasks: " + duplicateTasks);
        }
    }
}

