/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.sdk.workflow.def;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.conductor.client.exception.ConductorClientException;
import com.netflix.conductor.common.metadata.tasks.TaskDef;
import com.netflix.conductor.common.metadata.workflow.WorkflowDef;
import com.netflix.conductor.common.metadata.workflow.WorkflowTask;
import com.netflix.conductor.common.run.Workflow;
import com.netflix.conductor.sdk.workflow.def.tasks.Task;
import com.netflix.conductor.sdk.workflow.def.tasks.TaskRegistry;
import com.netflix.conductor.sdk.workflow.executor.WorkflowExecutor;
import com.netflix.conductor.sdk.workflow.utils.InputOutputGetter;
import com.netflix.conductor.sdk.workflow.utils.ObjectMapperProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;

public class ConductorWorkflow<T> {
    public static final InputOutputGetter input = new InputOutputGetter("workflow", InputOutputGetter.Field.input);
    public static final InputOutputGetter output = new InputOutputGetter("workflow", InputOutputGetter.Field.output);
    private String name;
    private String description;
    private int version;
    private String failureWorkflow;
    private String ownerEmail;
    private WorkflowDef.TimeoutPolicy timeoutPolicy;
    private Map<String, Object> workflowOutput;
    private long timeoutSeconds;
    private boolean restartable = true;
    private T defaultInput;
    private Map<String, Object> variables;
    private List<Task> tasks = new ArrayList<Task>();
    private final ObjectMapper objectMapper = new ObjectMapperProvider().getObjectMapper();
    private final WorkflowExecutor workflowExecutor;

    public ConductorWorkflow(WorkflowExecutor workflowExecutor) {
        this.workflowOutput = new HashMap<String, Object>();
        this.workflowExecutor = workflowExecutor;
        this.restartable = true;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setFailureWorkflow(String failureWorkflow) {
        this.failureWorkflow = failureWorkflow;
    }

    public void add(Task task) {
        this.tasks.add(task);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getVersion() {
        return this.version;
    }

    public String getFailureWorkflow() {
        return this.failureWorkflow;
    }

    public String getOwnerEmail() {
        return this.ownerEmail;
    }

    public void setOwnerEmail(String ownerEmail) {
        this.ownerEmail = ownerEmail;
    }

    public WorkflowDef.TimeoutPolicy getTimeoutPolicy() {
        return this.timeoutPolicy;
    }

    public void setTimeoutPolicy(WorkflowDef.TimeoutPolicy timeoutPolicy) {
        this.timeoutPolicy = timeoutPolicy;
    }

    public long getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public void setTimeoutSeconds(long timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    public boolean isRestartable() {
        return this.restartable;
    }

    public void setRestartable(boolean restartable) {
        this.restartable = restartable;
    }

    public T getDefaultInput() {
        return this.defaultInput;
    }

    public void setDefaultInput(T defaultInput) {
        this.defaultInput = defaultInput;
    }

    public Map<String, Object> getWorkflowOutput() {
        return this.workflowOutput;
    }

    public void setWorkflowOutput(Map<String, Object> workflowOutput) {
        this.workflowOutput = workflowOutput;
    }

    public Object getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public CompletableFuture<Workflow> executeDynamic(T input) {
        return this.workflowExecutor.executeWorkflow(this, input);
    }

    public CompletableFuture<Workflow> execute(T input) {
        return this.workflowExecutor.executeWorkflow(this.getName(), this.getVersion(), input);
    }

    public boolean registerWorkflow() {
        return this.registerWorkflow(false, false);
    }

    public boolean registerWorkflow(boolean overwrite) {
        return this.registerWorkflow(overwrite, false);
    }

    public boolean registerWorkflow(boolean overwrite, boolean registerTasks) {
        WorkflowDef workflowDef = this.toWorkflowDef();
        List<String> missing = this.getMissingTasks(workflowDef);
        if (!missing.isEmpty()) {
            if (!registerTasks) {
                throw new RuntimeException("Workflow cannot be registered.  The following tasks do not have definitions.  Please register these tasks before creating the workflow.  Missing Tasks = " + missing);
            }
            String ownerEmail = this.ownerEmail;
            missing.stream().forEach(taskName -> this.registerTaskDef((String)taskName, ownerEmail));
        }
        return this.workflowExecutor.registerWorkflow(workflowDef, overwrite);
    }

    public WorkflowDef toWorkflowDef() {
        WorkflowDef def = new WorkflowDef();
        def.setName(this.name);
        def.setDescription(this.description);
        def.setVersion(this.version);
        def.setFailureWorkflow(this.failureWorkflow);
        def.setOwnerEmail(this.ownerEmail);
        def.setTimeoutPolicy(this.timeoutPolicy);
        def.setTimeoutSeconds(this.timeoutSeconds);
        def.setRestartable(this.restartable);
        def.setOutputParameters(this.workflowOutput);
        def.setVariables(this.variables);
        def.setInputTemplate((Map)this.objectMapper.convertValue(this.defaultInput, Map.class));
        for (Task task : this.tasks) {
            def.getTasks().addAll(task.getWorkflowDefTasks());
        }
        return def;
    }

    public static <T> ConductorWorkflow<T> fromWorkflowDef(WorkflowDef def) {
        ConductorWorkflow<T> workflow = new ConductorWorkflow<T>(null);
        ConductorWorkflow.fromWorkflowDef(workflow, def);
        return workflow;
    }

    public ConductorWorkflow<T> from(String workflowName, Integer workflowVersion) {
        WorkflowDef def = this.workflowExecutor.getMetadataClient().getWorkflowDef(workflowName, workflowVersion);
        ConductorWorkflow.fromWorkflowDef(this, def);
        return this;
    }

    private static <T> void fromWorkflowDef(ConductorWorkflow<T> workflow, WorkflowDef def) {
        workflow.setName(def.getName());
        workflow.setVersion(def.getVersion());
        workflow.setFailureWorkflow(def.getFailureWorkflow());
        workflow.setRestartable(def.isRestartable());
        workflow.setVariables(def.getVariables());
        workflow.setDefaultInput(def.getInputTemplate());
        workflow.setWorkflowOutput(def.getOutputParameters());
        workflow.setOwnerEmail(def.getOwnerEmail());
        workflow.setDescription(def.getDescription());
        workflow.setTimeoutSeconds(def.getTimeoutSeconds());
        workflow.setTimeoutPolicy(def.getTimeoutPolicy());
        List workflowTasks = def.getTasks();
        for (WorkflowTask workflowTask : workflowTasks) {
            Task<?> task = TaskRegistry.getTask(workflowTask);
            workflow.tasks.add(task);
        }
    }

    private List<String> getMissingTasks(WorkflowDef workflowDef) {
        ArrayList<String> missing = new ArrayList<String>();
        ((Stream)workflowDef.collectTasks().stream().filter(workflowTask -> workflowTask.getType().equals("SIMPLE")).map(WorkflowTask::getName).distinct().parallel()).forEach(taskName -> {
            try {
                TaskDef taskDef = this.workflowExecutor.getMetadataClient().getTaskDef(taskName);
            }
            catch (ConductorClientException cce) {
                if (cce.getStatus() == 404) {
                    missing.add((String)taskName);
                }
                throw cce;
            }
        });
        return missing;
    }

    private void registerTaskDef(String taskName, String ownerEmail) {
        TaskDef taskDef = new TaskDef();
        taskDef.setName(taskName);
        taskDef.setOwnerEmail(ownerEmail);
        this.workflowExecutor.getMetadataClient().registerTaskDefs(Arrays.asList(taskDef));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConductorWorkflow workflow = (ConductorWorkflow)o;
        return this.version == workflow.version && Objects.equals(this.name, workflow.name);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version);
    }

    public String toString() {
        try {
            return this.objectMapper.writeValueAsString((Object)this.toWorkflowDef());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

