/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.sdk.healthcheck;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;

public class HealthCheckClient {
    private final String healthCheckURL;
    private final ObjectMapper objectMapper;

    public HealthCheckClient(String healthCheckURL) {
        this.healthCheckURL = healthCheckURL;
        this.objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public boolean isServerRunning() {
        try {
            String inputLine;
            BufferedReader in = new BufferedReader(new InputStreamReader(new URL(this.healthCheckURL).openStream()));
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            HealthCheckResults healthCheckResults = (HealthCheckResults)this.objectMapper.readValue(response.toString(), HealthCheckResults.class);
            return healthCheckResults.healthy;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static final class HealthCheckResults {
        private boolean healthy;

        private HealthCheckResults() {
        }

        public boolean isHealthy() {
            return this.healthy;
        }

        public void setHealthy(boolean healthy) {
            this.healthy = healthy;
        }
    }
}

