/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.sdk.example.shipment;

import com.netflix.conductor.common.metadata.workflow.WorkflowDef;
import com.netflix.conductor.common.run.Workflow;
import com.netflix.conductor.sdk.example.shipment.Order;
import com.netflix.conductor.sdk.example.shipment.Shipment;
import com.netflix.conductor.sdk.example.shipment.ShipmentState;
import com.netflix.conductor.sdk.workflow.def.ConductorWorkflow;
import com.netflix.conductor.sdk.workflow.def.WorkflowBuilder;
import com.netflix.conductor.sdk.workflow.def.tasks.DynamicFork;
import com.netflix.conductor.sdk.workflow.def.tasks.ForkJoin;
import com.netflix.conductor.sdk.workflow.def.tasks.SetVariable;
import com.netflix.conductor.sdk.workflow.def.tasks.SimpleTask;
import com.netflix.conductor.sdk.workflow.def.tasks.Switch;
import com.netflix.conductor.sdk.workflow.def.tasks.Task;
import com.netflix.conductor.sdk.workflow.def.tasks.Terminate;
import com.netflix.conductor.sdk.workflow.executor.WorkflowExecutor;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public class ShipmentWorkflow {
    private final WorkflowExecutor executor;

    public ShipmentWorkflow(WorkflowExecutor executor) {
        this.executor = executor;
        this.executor.initWorkers(ShipmentWorkflow.class.getPackageName());
    }

    public ConductorWorkflow<Order> createOrderFlow() {
        WorkflowBuilder builder = new WorkflowBuilder(this.executor);
        builder.name("order_flow").version(1).ownerEmail("user@example.com").timeoutPolicy(WorkflowDef.TimeoutPolicy.TIME_OUT_WF, 60L).description("Workflow to track shipment").add((Task)new SimpleTask("calculate_tax_and_total", "calculate_tax_and_total").input("orderDetail", ConductorWorkflow.input.get("orderDetail"))).add((Task)new SimpleTask("charge_payment", "charge_payment").input("billingId", ConductorWorkflow.input.map("userDetails").get("billingId"), "billingType", ConductorWorkflow.input.map("userDetails").get("billingType"), "amount", "${calculate_tax_and_total.output.total_amount}")).add(new Switch("shipping_label", "${workflow.input.orderDetail.shippingMethod}").switchCase(Order.ShippingMethod.GROUND.toString(), (Task)new SimpleTask("ground_shipping_label", "ground_shipping_label").input("name", ConductorWorkflow.input.map("userDetails").get("name"), "address", ConductorWorkflow.input.map("userDetails").get("addressLine"), "orderNo", ConductorWorkflow.input.map("orderDetail").get("orderNumber"))).switchCase(Order.ShippingMethod.NEXT_DAY_AIR.toString(), (Task)new SimpleTask("air_shipping_label", "air_shipping_label").input("name", ConductorWorkflow.input.map("userDetails").get("name"), "address", ConductorWorkflow.input.map("userDetails").get("addressLine"), "orderNo", ConductorWorkflow.input.map("orderDetail").get("orderNumber"))).switchCase(Order.ShippingMethod.SAME_DAY.toString(), (Task)new SimpleTask("same_day_shipping_label", "same_day_shipping_label").input("name", ConductorWorkflow.input.map("userDetails").get("name"), "address", ConductorWorkflow.input.map("userDetails").get("addressLine"), "orderNo", ConductorWorkflow.input.map("orderDetail").get("orderNumber"))).defaultCase(new Terminate("unsupported_shipping_type", Workflow.WorkflowStatus.FAILED, "Unsupported Shipping Method"))).add((Task)new SimpleTask("send_email", "send_email").input("name", ConductorWorkflow.input.map("userDetails").get("name"), "email", ConductorWorkflow.input.map("userDetails").get("email"), "orderNo", ConductorWorkflow.input.map("orderDetail").get("orderNumber")));
        ConductorWorkflow<Order> conductorWorkflow = builder.build();
        conductorWorkflow.registerWorkflow(true, true);
        return conductorWorkflow;
    }

    public ConductorWorkflow<Shipment> createShipmentWorkflow() {
        WorkflowBuilder builder = new WorkflowBuilder(this.executor);
        SimpleTask getOrderDetails = (SimpleTask)new SimpleTask("get_order_details", "get_order_details").input("orderNo", ConductorWorkflow.input.get("orderNo"));
        SimpleTask getUserDetails = (SimpleTask)new SimpleTask("get_user_details", "get_user_details").input("userId", ConductorWorkflow.input.get("userId"));
        ConductorWorkflow<Shipment> conductorWorkflow = builder.name("shipment_workflow").version(1).ownerEmail("user@example.com").variables(new ShipmentState()).timeoutPolicy(WorkflowDef.TimeoutPolicy.TIME_OUT_WF, 60L).description("Workflow to track shipment").add(new ForkJoin("get_in_parallel", {getOrderDetails}, {getUserDetails})).add(new DynamicFork("process_order", (SimpleTask)((SimpleTask)new SimpleTask("generateDynamicFork", "generateDynamicFork").input("orderDetails", getOrderDetails.taskOutput.get("result"))).input("userDetails", getUserDetails.taskOutput))).add((Task)new SetVariable("update_state").input("shipped", true)).build();
        conductorWorkflow.registerWorkflow(true, true);
        return conductorWorkflow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String conductorServerURL = "http://localhost:8080/api/";
        WorkflowExecutor executor = new WorkflowExecutor(conductorServerURL);
        ShipmentWorkflow shipmentWorkflow = new ShipmentWorkflow(executor);
        shipmentWorkflow.createOrderFlow();
        ConductorWorkflow<Shipment> workflow = shipmentWorkflow.createShipmentWorkflow();
        try {
            Shipment workflowInput = new Shipment("userA", "order123");
            CompletableFuture<Workflow> executionFuture = workflow.execute(workflowInput);
            Workflow run = executionFuture.get(1L, TimeUnit.MINUTES);
            System.out.println("Workflow Id: " + run);
            System.out.println("Workflow Status: " + run.getStatus());
            System.out.println("Workflow Output: " + run.getOutput());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            System.exit(0);
        }
        System.out.println("Done");
    }
}

