/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.run;

import com.netflix.conductor.annotations.protogen.ProtoField;
import com.netflix.conductor.annotations.protogen.ProtoMessage;
import com.netflix.conductor.common.metadata.tasks.Task;
import com.netflix.conductor.common.utils.SummaryUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;

@ProtoMessage
public class TaskSummary {
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    @ProtoField(id=1)
    private String workflowId;
    @ProtoField(id=2)
    private String workflowType;
    @ProtoField(id=3)
    private String correlationId;
    @ProtoField(id=4)
    private String scheduledTime;
    @ProtoField(id=5)
    private String startTime;
    @ProtoField(id=6)
    private String updateTime;
    @ProtoField(id=7)
    private String endTime;
    @ProtoField(id=8)
    private Task.Status status;
    @ProtoField(id=9)
    private String reasonForIncompletion;
    @ProtoField(id=10)
    private long executionTime;
    @ProtoField(id=11)
    private long queueWaitTime;
    @ProtoField(id=12)
    private String taskDefName;
    @ProtoField(id=13)
    private String taskType;
    @ProtoField(id=14)
    private String input;
    @ProtoField(id=15)
    private String output;
    @ProtoField(id=16)
    private String taskId;
    @ProtoField(id=17)
    private String externalInputPayloadStoragePath;
    @ProtoField(id=18)
    private String externalOutputPayloadStoragePath;
    @ProtoField(id=19)
    private int workflowPriority;
    @ProtoField(id=20)
    private String domain;

    public TaskSummary() {
    }

    public TaskSummary(Task task) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        sdf.setTimeZone(GMT);
        this.taskId = task.getTaskId();
        this.taskDefName = task.getTaskDefName();
        this.taskType = task.getTaskType();
        this.workflowId = task.getWorkflowInstanceId();
        this.workflowType = task.getWorkflowType();
        this.workflowPriority = task.getWorkflowPriority();
        this.correlationId = task.getCorrelationId();
        this.scheduledTime = sdf.format(new Date(task.getScheduledTime()));
        this.startTime = sdf.format(new Date(task.getStartTime()));
        this.updateTime = sdf.format(new Date(task.getUpdateTime()));
        this.endTime = sdf.format(new Date(task.getEndTime()));
        this.status = task.getStatus();
        this.reasonForIncompletion = task.getReasonForIncompletion();
        this.queueWaitTime = task.getQueueWaitTime();
        this.domain = task.getDomain();
        if (task.getInputData() != null) {
            this.input = SummaryUtil.serializeInputOutput(task.getInputData());
        }
        if (task.getOutputData() != null) {
            this.output = SummaryUtil.serializeInputOutput(task.getOutputData());
        }
        if (task.getEndTime() > 0L) {
            this.executionTime = task.getEndTime() - task.getStartTime();
        }
        if (StringUtils.isNotBlank((CharSequence)task.getExternalInputPayloadStoragePath())) {
            this.externalInputPayloadStoragePath = task.getExternalInputPayloadStoragePath();
        }
        if (StringUtils.isNotBlank((CharSequence)task.getExternalOutputPayloadStoragePath())) {
            this.externalOutputPayloadStoragePath = task.getExternalOutputPayloadStoragePath();
        }
    }

    public String getWorkflowId() {
        return this.workflowId;
    }

    public void setWorkflowId(String workflowId) {
        this.workflowId = workflowId;
    }

    public String getWorkflowType() {
        return this.workflowType;
    }

    public void setWorkflowType(String workflowType) {
        this.workflowType = workflowType;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public String getScheduledTime() {
        return this.scheduledTime;
    }

    public void setScheduledTime(String scheduledTime) {
        this.scheduledTime = scheduledTime;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public Task.Status getStatus() {
        return this.status;
    }

    public void setStatus(Task.Status status) {
        this.status = status;
    }

    public String getReasonForIncompletion() {
        return this.reasonForIncompletion;
    }

    public void setReasonForIncompletion(String reasonForIncompletion) {
        this.reasonForIncompletion = reasonForIncompletion;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public void setExecutionTime(long executionTime) {
        this.executionTime = executionTime;
    }

    public long getQueueWaitTime() {
        return this.queueWaitTime;
    }

    public void setQueueWaitTime(long queueWaitTime) {
        this.queueWaitTime = queueWaitTime;
    }

    public String getTaskDefName() {
        return this.taskDefName;
    }

    public void setTaskDefName(String taskDefName) {
        this.taskDefName = taskDefName;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getExternalInputPayloadStoragePath() {
        return this.externalInputPayloadStoragePath;
    }

    public void setExternalInputPayloadStoragePath(String externalInputPayloadStoragePath) {
        this.externalInputPayloadStoragePath = externalInputPayloadStoragePath;
    }

    public String getExternalOutputPayloadStoragePath() {
        return this.externalOutputPayloadStoragePath;
    }

    public void setExternalOutputPayloadStoragePath(String externalOutputPayloadStoragePath) {
        this.externalOutputPayloadStoragePath = externalOutputPayloadStoragePath;
    }

    public int getWorkflowPriority() {
        return this.workflowPriority;
    }

    public void setWorkflowPriority(int workflowPriority) {
        this.workflowPriority = workflowPriority;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskSummary that = (TaskSummary)o;
        return this.getExecutionTime() == that.getExecutionTime() && this.getQueueWaitTime() == that.getQueueWaitTime() && this.getWorkflowPriority() == that.getWorkflowPriority() && this.getWorkflowId().equals(that.getWorkflowId()) && this.getWorkflowType().equals(that.getWorkflowType()) && Objects.equals(this.getCorrelationId(), that.getCorrelationId()) && this.getScheduledTime().equals(that.getScheduledTime()) && Objects.equals(this.getStartTime(), that.getStartTime()) && Objects.equals(this.getUpdateTime(), that.getUpdateTime()) && Objects.equals(this.getEndTime(), that.getEndTime()) && this.getStatus() == that.getStatus() && Objects.equals(this.getReasonForIncompletion(), that.getReasonForIncompletion()) && Objects.equals(this.getTaskDefName(), that.getTaskDefName()) && this.getTaskType().equals(that.getTaskType()) && this.getTaskId().equals(that.getTaskId()) && Objects.equals(this.getDomain(), that.getDomain());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getWorkflowId(), this.getWorkflowType(), this.getCorrelationId(), this.getScheduledTime(), this.getStartTime(), this.getUpdateTime(), this.getEndTime(), this.getStatus(), this.getReasonForIncompletion(), this.getExecutionTime(), this.getQueueWaitTime(), this.getTaskDefName(), this.getTaskType(), this.getTaskId(), this.getWorkflowPriority(), this.getDomain()});
    }
}

