/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.cubano.driver.web.provider;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import org.concordion.cubano.driver.web.provider.BrowserProvider;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;

public abstract class RemoteBrowserProvider
implements BrowserProvider {
    protected static final String DEFAULT_DESKTOP_SCREENSIZE = "1024x768";
    protected static final String DEFAULT_DESKTOP_VIEWPORT = "950x600";
    private String browser;
    private String viewPort;
    private DesiredCapabilities capabilites;

    protected RemoteBrowserProvider() {
    }

    protected abstract String getRemoteDriverUrl();

    protected void setDetails(String browser, String viewPort, DesiredCapabilities capabilites) {
        this.browser = browser;
        this.viewPort = viewPort;
        this.capabilites = capabilites;
    }

    public String getBrowser() {
        return this.browser;
    }

    public String getViewPort() {
        return this.viewPort;
    }

    private DesiredCapabilities getCapabilites() {
        return this.capabilites;
    }

    @Override
    public WebDriver createDriver() {
        URL url;
        try {
            url = new URL(this.getRemoteDriverUrl());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return new RemoteWebDriver(url, (Capabilities)this.getCapabilites());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteBrowserProvider compare = (RemoteBrowserProvider)obj;
        if (!this.areEqual(this.getCapabilites(), compare.getCapabilites())) {
            return false;
        }
        if (!this.areEqual(this.getBrowser(), compare.getBrowser())) {
            return false;
        }
        return this.areEqual(this.getViewPort(), compare.getViewPort());
    }

    public int hashCode() {
        return Objects.hash(this.browser, this.capabilites, this.viewPort);
    }

    public boolean isViewPortDefined() {
        return this.getViewPort() != null && !this.getViewPort().isEmpty();
    }

    public int getViewPortWidth() {
        if (!this.isViewPortDefined()) {
            return -1;
        }
        String width = this.getViewPort().substring(0, this.getViewPort().indexOf("x")).trim();
        return Integer.parseInt(width);
    }

    public int getViewPortHeight() {
        if (!this.isViewPortDefined()) {
            return -1;
        }
        String height = this.getViewPort().substring(this.getViewPort().indexOf("x") + 1).trim();
        return Integer.parseInt(height);
    }

    private boolean areEqual(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 == null) {
            return false;
        }
        if (obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    @Override
    public void close() {
    }
}

