/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.cubano.driver.web.provider;

import org.concordion.cubano.driver.web.config.WebDriverConfig;
import org.concordion.cubano.driver.web.provider.RemoteBrowserProvider;
import org.openqa.selenium.remote.DesiredCapabilities;

public class BrowserStackBrowserProvider
extends RemoteBrowserProvider {
    private static final String REMOTE_URL = "http://[USER_NAME]:[API_KEY]@hub.browserstack.com/wd/hub";
    private static final String TYPE = "application/json";

    public BrowserStackBrowserProvider() {
        String[] browserDetails;
        String browser = null;
        if (browser == null) {
            browser = "";
        }
        if ((browserDetails = browser.split(" ")).length <= 2) {
            String version = "";
            if (browserDetails.length == 2) {
                version = browserDetails[1];
            }
            switch (browserDetails[0]) {
                case "chrome": {
                    this.chrome(version);
                    break;
                }
                case "internetExplorer": 
                case "ie": {
                    this.internetExplorer(version);
                    break;
                }
                case "firefox": {
                    this.firefox(version);
                    break;
                }
                case "safari": {
                    this.safari(version);
                    break;
                }
            }
        }
        switch (browser) {
            case "iphone 6s plus": {
                this.iPhone6SPlusEmulator();
                break;
            }
            case "google nexus 5": {
                this.googleNexus5Emulator();
                break;
            }
        }
        throw new RuntimeException("Browser '" + browser + "' is not currently supported");
    }

    @Override
    protected String getRemoteDriverUrl() {
        return REMOTE_URL.replace("[USER_NAME]", WebDriverConfig.getInstance().getRemoteUserName()).replace("[API_KEY]", WebDriverConfig.getInstance().getRemoteApiKey());
    }

    protected void desktop(DesiredCapabilities caps, String browserVersion) {
        String browserName = caps.getCapability("browser").toString();
        caps.setCapability("browser_version", browserVersion);
        caps.setCapability("resolution", "1024x768");
        this.setDetails(browserName, "950x600", caps);
    }

    protected void firefox(String browserVersion) {
        DesiredCapabilities caps = new DesiredCapabilities();
        caps.setCapability("browser", "Firefox");
        caps.setCapability("os", "Windows");
        caps.setCapability("os_version", "10");
        this.desktop(caps, browserVersion);
    }

    protected void chrome(String browserVersion) {
        DesiredCapabilities caps = new DesiredCapabilities();
        caps.setCapability("browser", "Chrome");
        caps.setCapability("os", "Windows");
        caps.setCapability("os_version", "10");
        this.desktop(caps, browserVersion);
    }

    protected void internetExplorer(String browserVersion) {
        DesiredCapabilities caps = new DesiredCapabilities();
        caps.setCapability("browser", "IE");
        caps.setCapability("os", "Windows");
        caps.setCapability("os_version", "10");
        this.desktop(caps, browserVersion);
    }

    protected void safari(String browserVersion) {
        DesiredCapabilities caps = new DesiredCapabilities();
        caps.setCapability("browser", "Safari");
        caps.setCapability("os", "OS X");
        caps.setCapability("os_version", "El Capitan");
        this.desktop(caps, browserVersion);
    }

    protected void samsungGalaxyS5Emulator() {
        DesiredCapabilities caps = new DesiredCapabilities();
        caps.setCapability("browserName", "android");
        caps.setCapability("platform", "ANDROID");
        caps.setCapability("device", "Samsung Galaxy S5");
        this.setDetails("Samsung Galaxy S5", "1080x1920", caps);
    }

    protected void iPhone6SPlusEmulator() {
        DesiredCapabilities caps = new DesiredCapabilities();
        caps.setCapability("browserName", "iPhone");
        caps.setCapability("platform", "MAC");
        caps.setCapability("device", "iPhone 6S Plus");
        this.setDetails("iPhone 6S Plus", "?x?", caps);
    }

    protected void googleNexus5Emulator() {
        DesiredCapabilities caps = new DesiredCapabilities();
        caps.setCapability("browserName", "android");
        caps.setCapability("platform", "ANDROID");
        caps.setCapability("device", "Google Nexus 5");
        this.setDetails("Google Nexus 5", "1080x1920", caps);
    }
}

