/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.cubano.driver.web.pagefactory;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import org.concordion.cubano.driver.web.BasePageObject;
import org.concordion.cubano.driver.web.pagefactory.PageObjectAware;
import org.concordion.cubano.driver.web.pagefactory.PageObjectAwareHtmlElementDecorator;
import org.concordion.cubano.driver.web.pagefactory.WebDriverAware;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsDriver;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.pagefactory.FieldDecorator;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.TypifiedElement;
import ru.yandex.qatools.htmlelements.exceptions.HtmlElementsException;
import ru.yandex.qatools.htmlelements.loader.HtmlElementLoader;
import ru.yandex.qatools.htmlelements.loader.decorator.HtmlElementLocatorFactory;
import ru.yandex.qatools.htmlelements.pagefactory.CustomElementLocatorFactory;
import ru.yandex.qatools.htmlelements.utils.HtmlElementUtils;

public class PageObjectAwareHtmlElementsLoader
implements WrapsDriver {
    private final WebDriver driver;
    private BasePageObject<?> pageObject;

    public PageObjectAwareHtmlElementsLoader(WebDriver driver, BasePageObject<?> pageObject) {
        this.driver = driver;
        this.pageObject = pageObject;
    }

    public WebDriver getWrappedDriver() {
        return this.driver;
    }

    public Field getFieldFromClass(Class<?> elementClass, String fieldName) {
        try {
            return elementClass.getDeclaredField(fieldName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public <T extends HtmlElement> List<T> findElements(Class<T> elementClass, By by) {
        return this.findElements(elementClass, by, null);
    }

    public <T extends HtmlElement> List<T> findElements(Class<T> elementClass, By by, Field field) {
        String name = null;
        if (field != null) {
            name = HtmlElementUtils.getElementName((Field)field);
        }
        LinkedList<T> elements = new LinkedList<T>();
        for (WebElement element : this.driver.findElements(by)) {
            elements.add(PageObjectAwareHtmlElementsLoader.createHtmlElement(elementClass, element, name, this.pageObject));
        }
        return elements;
    }

    public <T extends HtmlElement> T findElement(Class<T> elementClass, By by) {
        WebElement element = this.driver.findElement(by);
        return PageObjectAwareHtmlElementsLoader.createHtmlElement(elementClass, element, null, this.pageObject);
    }

    public <T extends TypifiedElement> T findTypifiedElement(Class<T> elementClass, By by) {
        WebElement element = this.driver.findElement(by);
        TypifiedElement instance = HtmlElementLoader.createTypifiedElement(elementClass, (WebElement)element, (String)"");
        PageObjectAwareHtmlElementsLoader.setAwareValue(instance, this.pageObject);
        return (T)instance;
    }

    public static <T extends TypifiedElement> T createTypifiedElement(Class<T> elementClass, WebElement elementToWrap, String name, BasePageObject<?> parentPageObject) {
        try {
            TypifiedElement instance = (TypifiedElement)HtmlElementUtils.newInstance(elementClass, (Object[])new Object[]{elementToWrap});
            instance.setName(name);
            PageObjectAwareHtmlElementsLoader.setAwareValue(instance, parentPageObject);
            return (T)instance;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new HtmlElementsException((Throwable)e);
        }
    }

    public static <T extends HtmlElement> T createHtmlElement(Class<T> elementClass, WebElement elementToWrap, String name, BasePageObject<?> parentPageObject) {
        try {
            HtmlElement instance = (HtmlElement)HtmlElementUtils.newInstance(elementClass, (Object[])new Object[0]);
            instance.setWrappedElement(elementToWrap);
            instance.setName(name);
            PageObjectAwareHtmlElementsLoader.setAwareValue(instance, parentPageObject);
            PageObjectAwareHtmlElementsLoader.populatePageObject(instance, (SearchContext)elementToWrap, parentPageObject);
            return (T)instance;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new HtmlElementsException((Throwable)e);
        }
    }

    private static void populatePageObject(Object instance, SearchContext searchContext, BasePageObject<?> parentPageObject) {
        PageFactory.initElements((FieldDecorator)new PageObjectAwareHtmlElementDecorator((CustomElementLocatorFactory)new HtmlElementLocatorFactory(searchContext), parentPageObject), (Object)instance);
    }

    public static void setAwareValue(Object element, BasePageObject<?> parentPageObject) {
        if (element instanceof WebDriverAware) {
            ((WebDriverAware)element).setWebDriver(parentPageObject.getBrowser().getDriver());
        }
        if (element instanceof PageObjectAware) {
            ((PageObjectAware)element).setPageObject(parentPageObject);
        }
    }
}

