/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.cubano.driver.web;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.concordion.cubano.driver.BrowserBasedTest;
import org.concordion.cubano.driver.web.BasePageObject;
import org.concordion.ext.ScreenshotTaker;
import org.concordion.ext.StoryboardMarker;
import org.concordion.ext.StoryboardMarkerFactory;
import org.concordion.ext.storyboard.CardResult;
import org.concordion.slf4j.ext.FluentLogger;
import org.concordion.slf4j.ext.ReportLogger;
import org.concordion.slf4j.ext.ReportLoggerFactory;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Marker;

public class PageHelper {
    private static final ReportLogger LOGGER = ReportLoggerFactory.getReportLogger(PageHelper.class);
    private final BasePageObject<?> pageObject;
    private final Class<?> logLocation;

    public PageHelper(BasePageObject<?> pageObject) {
        this.pageObject = pageObject;
        this.logLocation = null;
    }

    public PageHelper(BasePageObject<?> pageObject, Class<?> logLocation) {
        this.pageObject = pageObject;
        this.logLocation = logLocation;
    }

    public void triggerCheckPage(WebElement triggerElement, String tag) {
        throw new UnsupportedOperationException();
    }

    public void checkWindow(String tag) {
        this.triggerCheckPage(null, tag);
    }

    public void checkRegion(WebElement region, String tag) {
        this.triggerCheckPage(region, tag);
    }

    public boolean isElementPresent(WebElement element) {
        try {
            element.isDisplayed();
            return true;
        }
        catch (NoSuchElementException ex) {
            return false;
        }
    }

    public boolean isElementVisible(WebElement element) {
        try {
            return element.isDisplayed();
        }
        catch (NoSuchElementException ex) {
            return false;
        }
    }

    public static boolean isElementPresent(WebDriver driver, By by) {
        try {
            driver.findElement(by).isDisplayed();
            return true;
        }
        catch (NoSuchElementException ex) {
            return false;
        }
    }

    public static boolean isElementVisible(WebDriver driver, By by) {
        try {
            return driver.findElement(by).isDisplayed();
        }
        catch (NoSuchElementException ex) {
            return false;
        }
    }

    public void capturePage(WebElement element) {
        this.capturePage(element, this.getClickMessage(element));
    }

    public void capturePage(WebElement element, String description) {
        this.capturePage(element, description, CardResult.SUCCESS);
    }

    public void capturePage(ScreenshotTaker screenshotTaker, String description) {
        this.capture(screenshotTaker, description, StoryboardMarkerFactory.addCard((String)this.pageObject.getSimpleName()));
    }

    public void capturePage(WebElement element, String description, CardResult result) {
        ScreenshotTaker screenshotTaker;
        try {
            screenshotTaker = this.pageObject.getBrowser().getScreenshotTakerClass().getDeclaredConstructor(WebDriver.class, WebElement.class).newInstance(this.pageObject.getBrowser().getDriver(), element);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            if (e.getMessage() == null && e.getCause() != null) {
                throw new RuntimeException(e.getCause());
            }
            throw new RuntimeException(e);
        }
        this.capture(screenshotTaker, description, StoryboardMarkerFactory.addCard((String)this.pageObject.getSimpleName(), null, (CardResult)result));
    }

    private void capture(ScreenshotTaker screenshotTaker, String description, StoryboardMarker storyboardMarker) {
        FluentLogger flogger = this.pageObject.getLogger().with().message(description, new Object[0]).screenshot(screenshotTaker).marker((Marker)storyboardMarker);
        if (this.logLocation != null) {
            flogger.locationAwareParent(this.logLocation);
        }
        flogger.debug();
    }

    public <P extends BasePageObject<P>> P capturePageAndClick(WebElement element, Class<P> expectedPage, Object ... params) {
        return this.capturePageAndClick(element, this.getClickMessage(element), expectedPage, params);
    }

    public <P extends BasePageObject<P>> P capturePageAndClick(WebElement element, String description, Class<P> expectedPage, Object ... params) {
        return this.capturePageAndClick(element, 10, description, expectedPage, params);
    }

    public <P extends BasePageObject<P>> P capturePageAndClick(WebElement element, int timeoutSeconds, String description, Class<P> expectedPage, Object ... params) {
        this.waitForElementToClickable(element, timeoutSeconds);
        this.capturePage(element, description);
        this.waitAndClickElement(element, timeoutSeconds);
        if (expectedPage == null) {
            return null;
        }
        return this.newInstance(expectedPage, params);
    }

    public void waitForElementToClickable(WebElement webElement, int timeOutInSeconds) {
        new WebDriverWait(this.pageObject.getBrowser().getDriver(), (long)timeOutInSeconds).ignoring(WebDriverException.class).until(d -> {
            ExpectedConditions.elementToBeClickable((WebElement)webElement);
            return true;
        });
    }

    private void waitAndClickElement(WebElement element, int timeoutSeconds) {
        new WebDriverWait(this.pageObject.getBrowser().getDriver(), (long)timeoutSeconds).ignoring(WebDriverException.class).until(d -> {
            element.click();
            return true;
        });
    }

    public <P extends BasePageObject<P>> P newInstance(Class<P> expectedPage, Object ... params) {
        try {
            if (params.length > 0) {
                Class[] constructorArguments = new Class[]{BrowserBasedTest.class, Object[].class};
                return (P)((BasePageObject)expectedPage.getDeclaredConstructor(constructorArguments).newInstance(this.getTest(), params));
            }
            return (P)((BasePageObject)expectedPage.getDeclaredConstructor(BrowserBasedTest.class).newInstance(this.getTest()));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            if (e.getMessage() == null && e.getCause() != null) {
                throw new RuntimeException(e.getCause());
            }
            throw new RuntimeException(e);
        }
    }

    public WebElement getFirstVisibleElement(List<WebElement> webElements) {
        for (WebElement webElement : webElements) {
            if (!webElement.isDisplayed()) continue;
            return webElement;
        }
        return null;
    }

    private BrowserBasedTest getTest() {
        return this.pageObject.getTest();
    }

    public String getCurrentFrameNameOrId() {
        return PageHelper.getCurrentFrameNameOrId(this.pageObject.getBrowser().getDriver());
    }

    public static String getCurrentFrameNameOrId(WebDriver driver) {
        String script = "var frame = window.frameElement;if (!frame) {    return '';}if (frame.name) {    return frame.name;}if (frame.id) {    return frame.id;}return 'UNKNOWN FRAME';";
        return (String)((JavascriptExecutor)driver).executeScript(script, new Object[0]);
    }

    public static WebElement getCurrentFrame(WebDriver driver) {
        return (WebElement)((JavascriptExecutor)driver).executeScript("return window.frameElement", new Object[0]);
    }

    public void switchToMainDocument() {
        PageHelper.switchToMainDocument(this.pageObject.getBrowser().getDriver());
    }

    public static void switchToMainDocument(WebDriver driver) {
        driver.switchTo().defaultContent();
        driver.switchTo().window(driver.getWindowHandle());
        for (int i = 0; i < 10; ++i) {
            try {
                String currentFrame = PageHelper.getCurrentFrameNameOrId(driver);
                if (currentFrame.isEmpty()) {
                    break;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            driver.switchTo().parentFrame();
        }
    }

    private String getClickMessage(WebElement element) {
        this.waitForElementToClickable(element, 10);
        String label = element.getText();
        if (label == null || label.isEmpty()) {
            label = element.getAttribute("value");
        }
        return "Clicking '" + label + "' ";
    }

    public void acceptAlertIfPresent() {
        PageHelper.acceptAlertIfPresent(this.pageObject.getBrowser().getDriver());
    }

    public static void acceptAlertIfPresent(WebDriver driver) {
        try {
            PageHelper.waitUntil(driver, ExpectedConditions.alertIsPresent(), 1);
            Alert alert = driver.switchTo().alert();
            LOGGER.debug("Accepting alert \"{}\"", (Object)alert.getText());
            alert.accept();
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    public static void waitUntil(WebDriver driver, ExpectedCondition<?> condition, int timeOutInSeconds) {
        WebDriverWait wait = new WebDriverWait(driver, (long)timeOutInSeconds);
        wait.until(condition);
    }
}

