/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.cubano.driver.web;

import java.util.List;
import org.concordion.cubano.driver.BrowserBasedTest;
import org.concordion.cubano.driver.web.Browser;
import org.concordion.cubano.driver.web.PageHelper;
import org.concordion.cubano.driver.web.pagefactory.PageObjectAwareHtmlElementDecorator;
import org.concordion.ext.ScreenshotTaker;
import org.concordion.ext.storyboard.CardResult;
import org.concordion.slf4j.ext.ReportLogger;
import org.concordion.slf4j.ext.ReportLoggerFactory;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.pagefactory.FieldDecorator;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;
import ru.yandex.qatools.htmlelements.loader.decorator.HtmlElementLocatorFactory;
import ru.yandex.qatools.htmlelements.pagefactory.CustomElementLocatorFactory;

public abstract class BasePageObject<T extends BasePageObject<T>> {
    private final ReportLogger logger = ReportLoggerFactory.getReportLogger((String)this.getClass().getName());
    private BrowserBasedTest test;
    private PageHelper pageHelper;

    protected BasePageObject(BrowserBasedTest test, int timeoutWaitInSeconds, Object ... params) {
        this.test = test;
        this.pageHelper = new PageHelper(this, BasePageObject.class);
        this.getLogger().step("Page Object: {}", new Object[]{this.getSimpleName()});
        this.refreshPageElements();
        this.waitUntilPageIsLoaded(timeoutWaitInSeconds, params);
    }

    public void refreshPageElements() {
        PageFactory.initElements((FieldDecorator)new PageObjectAwareHtmlElementDecorator((CustomElementLocatorFactory)new HtmlElementLocatorFactory((SearchContext)this.getBrowser().getDriver()), this), (Object)this);
    }

    protected abstract void waitUntilPageIsLoaded(int var1, Object ... var2);

    public String getSimpleName() {
        return this.getClass().getSimpleName();
    }

    public ReportLogger getLogger() {
        return this.logger;
    }

    public BrowserBasedTest getTest() {
        return this.test;
    }

    public Browser getBrowser() {
        return this.test.getBrowser();
    }

    public T checkWindow() {
        this.pageHelper.checkWindow(this.getSimpleName());
        return (T)this;
    }

    public T checkRegion(WebElement region) {
        this.pageHelper.checkRegion(region, this.getSimpleName());
        return (T)this;
    }

    protected static void ignoreSecurityCertificateWarning(Browser browser) {
        if (browser.getDriver().getTitle().equals("Certificate Error: Navigation Blocked")) {
            browser.getDriver().navigate().to("javascript:document.getElementById('overridelink').click()");
        }
    }

    protected boolean isElementPresent(WebElement element) {
        return this.pageHelper.isElementPresent(element);
    }

    protected static boolean isElementPresent(WebDriver driver, By by) {
        return PageHelper.isElementPresent(driver, by);
    }

    protected T capturePage(WebElement element) {
        this.pageHelper.capturePage(element);
        return (T)this;
    }

    public T capturePage(String description) {
        this.pageHelper.capturePage((WebElement)null, description);
        return (T)this;
    }

    public T capturePage(WebElement element, String description) {
        this.pageHelper.capturePage(element, description);
        return (T)this;
    }

    public T capturePage(ScreenshotTaker screenshotTaker, String description) {
        this.pageHelper.capturePage(screenshotTaker, description);
        return (T)this;
    }

    public T capturePage(WebElement element, String description, CardResult result) {
        this.pageHelper.capturePage(element, description, result);
        return (T)this;
    }

    public <P extends BasePageObject<P>> P capturePageAndClick(WebElement element, Class<P> expectedPage, Object ... params) {
        return this.pageHelper.capturePageAndClick(element, expectedPage, params);
    }

    public <P extends BasePageObject<P>> P capturePageAndClick(WebElement element, String description, Class<P> expectedPage, Object ... params) {
        return this.pageHelper.capturePageAndClick(element, description, expectedPage, params);
    }

    public <P extends BasePageObject<P>> P capturePageAndClick(WebElement element, int timeoutSeconds, String description, Class<P> expectedPage, Object ... params) {
        return this.pageHelper.capturePageAndClick(element, timeoutSeconds, description, expectedPage, params);
    }

    public <P extends BasePageObject<P>> P newInstance(Class<P> expectedPage, Object ... params) {
        return this.pageHelper.newInstance(expectedPage, params);
    }

    public void waitForElementToClickable(WebElement webElement, int timeOutInSeconds) {
        this.pageHelper.waitForElementToClickable(webElement, timeOutInSeconds);
    }

    protected WebElement getFirstVisibleElement(List<WebElement> webElements) {
        return this.pageHelper.getFirstVisibleElement(webElements);
    }

    public void prepareForScreenshot() {
    }

    protected void waitUntil(ExpectedCondition<?> condition, int timeOutInSeconds) {
        WebDriverWait wait = new WebDriverWait(this.getBrowser().getDriver(), (long)timeOutInSeconds);
        wait.ignoring(WebDriverException.class);
        wait.until(condition);
    }

    public void switchToMainDocument() {
        this.pageHelper.switchToMainDocument();
    }

    public String getCurrentFrameNameOrId() {
        return this.pageHelper.getCurrentFrameNameOrId();
    }
}

