/*
 * Decompiled with CFR 0.152.
 */
package org.conceptoriented.bistro.server.connectors;

import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import org.conceptoriented.bistro.core.BistroError;
import org.conceptoriented.bistro.server.Action;
import org.conceptoriented.bistro.server.ConnectorBase;
import org.conceptoriented.bistro.server.Context;
import org.conceptoriented.bistro.server.Server;
import org.conceptoriented.bistro.server.Task;

public class ConnectorTimer
extends ConnectorBase {
    Timer timer = new Timer("Bistro Server: ConnectorTimer Timer");
    long period;

    @Override
    public void start() throws BistroError {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.addAll(this.getActions());
        Context ctx = new Context();
        ctx.server = this.server;
        ctx.schema = this.server.getSchema();
        final Task task = new Task(actions, ctx);
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                ConnectorTimer.this.server.submit(task);
            }
        };
        this.timer.schedule(timerTask, this.period, this.period);
    }

    @Override
    public void stop() throws BistroError {
        this.timer.cancel();
    }

    public ConnectorTimer(Server server, long period) {
        super(server);
        this.period = period;
    }
}

