/*
 * Decompiled with CFR 0.152.
 */
package org.conceptoriented.bistro.server.connectors;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.conceptoriented.bistro.core.BistroError;
import org.conceptoriented.bistro.core.Column;
import org.conceptoriented.bistro.core.Table;
import org.conceptoriented.bistro.server.Action;
import org.conceptoriented.bistro.server.ConnectorBase;
import org.conceptoriented.bistro.server.Server;
import org.conceptoriented.bistro.server.Task;
import org.conceptoriented.bistro.server.actions.ActionAdd;

public class ConnectorSimulator
extends ConnectorBase
implements Runnable {
    Table table;
    Duration delay;
    List<Duration> delays;
    List<Object[]> data;
    Thread thread;

    @Override
    public void run() {
        long delay_millis = 100L;
        int start = 0;
        int end = 0;
        long submissionTime = System.nanoTime();
        List columns = this.table.getColumns();
        while (start < this.data.size()) {
            while (end < this.data.size()) {
                delay_millis = this.delays == null ? this.delay.toMillis() : this.delays.get(end).toMillis();
                if (delay_millis > 0L) {
                    ++end;
                    break;
                }
                ++end;
            }
            ArrayList<Action> toSubmit = new ArrayList<Action>();
            while (start < end) {
                HashMap<Column, Object> record = new HashMap<Column, Object>();
                record.put((Column)columns.get(0), Instant.now());
                Object[] rec = this.data.get(start);
                for (int i = 0; i < rec.length && i < columns.size(); ++i) {
                    record.put((Column)columns.get(i + 1), rec[i]);
                }
                toSubmit.add(new ActionAdd(this.table, record));
                ++start;
            }
            toSubmit.addAll(this.getActions());
            Task task = new Task(toSubmit, null);
            long restNanos = delay_millis * 1000000L - (System.nanoTime() - submissionTime);
            if (restNanos > 10L) {
                try {
                    Thread.sleep(restNanos / 1000000L, (int)(restNanos % 1000000L));
                }
                catch (InterruptedException e) {
                    if (Thread.currentThread().isInterrupted()) break;
                }
            }
            submissionTime = System.nanoTime();
            this.server.submit(task);
        }
    }

    @Override
    public void start() throws BistroError {
        this.thread = new Thread((Runnable)this, "Bistro ConnectorSimulator Thread");
        this.thread.start();
    }

    @Override
    public void stop() throws BistroError {
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
    }

    public ConnectorSimulator(Server server, Table table, Duration delay, List<Object[]> data) {
        super(server);
        this.table = table;
        this.delay = delay;
        this.delays = null;
        this.data = data;
    }

    public ConnectorSimulator(Server server, Table table, List<Duration> delays, List<Object[]> data) {
        super(server);
        this.table = table;
        this.delay = null;
        this.delays = delays;
        this.data = data;
    }
}

