/*
 * Decompiled with CFR 0.152.
 */
package org.conceptoriented.bistro.server;

import java.util.ArrayList;
import java.util.List;
import org.conceptoriented.bistro.core.BistroError;
import org.conceptoriented.bistro.core.BistroErrorCode;
import org.conceptoriented.bistro.server.Action;
import org.conceptoriented.bistro.server.Context;

public class Task
implements Runnable {
    protected List<Action> actions = new ArrayList<Action>();
    protected Context context;

    @Override
    public void run() {
        for (Action a : this.actions) {
            try {
                a.evaluate(this.context);
            }
            catch (BistroError bistroError) {
                bistroError.printStackTrace();
                this.context.server.addError(new BistroError(BistroErrorCode.DEFINITION_ERROR, "Error executing action.", bistroError.message));
                return;
            }
        }
    }

    public Task(List<Action> actions, Context context) {
        this.actions.addAll(actions);
        this.context = context;
    }

    public Task(Action action, Context context) {
        this.actions.add(action);
        this.context = context;
    }
}

