/*
 * Decompiled with CFR 0.152.
 */
package org.conceptoriented.bistro.server;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.conceptoriented.bistro.core.BistroError;
import org.conceptoriented.bistro.core.Schema;
import org.conceptoriented.bistro.server.Action;
import org.conceptoriented.bistro.server.Context;
import org.conceptoriented.bistro.server.Task;

public class Server {
    Schema schema;
    ReentrantLock schemaLock = new ReentrantLock();
    protected List<BistroError> errors = new ArrayList<BistroError>();
    BlockingQueue<Runnable> queue;
    ExecutorService executor;

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public List<BistroError> getErrors() {
        return this.errors;
    }

    public void addError(BistroError error) {
        this.errors.add(error);
    }

    public void start() throws BistroError {
        this.errors.clear();
        int n = 1;
        this.queue = new ArrayBlockingQueue<Runnable>(1000);
        this.executor = new ThreadPoolExecutor(n, n, 0L, TimeUnit.MILLISECONDS, this.queue);
    }

    public void stop() throws BistroError {
        if (this.executor != null) {
            try {
                System.out.println("Attempt to shutdown executor");
                this.executor.shutdown();
                this.executor.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                System.err.println("tasks interrupted");
            }
            finally {
                if (!this.executor.isTerminated()) {
                    System.err.println("Cancel non-finished tasks");
                    this.executor.shutdownNow();
                }
                this.executor = null;
            }
        }
        this.queue = null;
    }

    public void submit(Task task) {
        long submitTime = System.currentTimeMillis();
        this.executor.submit(task);
    }

    public void submit(Action action, Context context) {
        this.submit(new Task(action, context));
    }

    public void submit(Action action) {
        this.submit(new Task(action, null));
    }

    public String toString() {
        return "Server";
    }

    public Server(Schema schema) {
        this.schema = schema;
    }
}

