/*
 * Decompiled with CFR 0.152.
 */
package org.comroid.restless.server;

import com.sun.net.httpserver.Headers;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.comroid.restless.REST;
import org.comroid.restless.endpoint.AccessibleEndpoint;
import org.comroid.restless.server.EndpointHandler;
import org.comroid.uniform.node.UniNode;

public interface ServerEndpoint
extends AccessibleEndpoint,
EndpointHandler {
    public AccessibleEndpoint getEndpointBase();

    @Override
    default public Pattern getPattern() {
        return this.getEndpointBase().getPattern();
    }

    @Override
    default public String getUrlBase() {
        return this.getEndpointBase().getUrlBase();
    }

    @Override
    default public String getUrlExtension() {
        return this.getEndpointBase().getUrlExtension();
    }

    @Override
    default public String[] getRegExpGroups() {
        return this.getEndpointBase().getRegExpGroups();
    }

    public static ServerEndpoint combined(AccessibleEndpoint accessibleEndpoint, EndpointHandler handler) {
        return new Support.Combined(accessibleEndpoint, handler);
    }

    default public boolean allowMemberAccess() {
        return false;
    }

    @Override
    default public ServerEndpoint attachHandler(EndpointHandler handler) {
        throw new UnsupportedOperationException("Cannot attach Handler to ServerEndpoint");
    }

    default public boolean isMemberAccess(String url) {
        return this.allowMemberAccess() && Stream.of(this.replacer(this.getRegExpGroups()), url).mapToLong(str -> str.chars().filter(x -> x == 47).count()).distinct().count() > 1L;
    }

    public static final class Support {

        private static final class Combined
        implements ServerEndpoint {
            private final AccessibleEndpoint accessibleEndpoint;
            private final EndpointHandler handler;

            @Override
            public AccessibleEndpoint getEndpointBase() {
                return this.accessibleEndpoint;
            }

            public Combined(AccessibleEndpoint accessibleEndpoint, EndpointHandler handler) {
                this.accessibleEndpoint = accessibleEndpoint;
                this.handler = handler;
            }

            @Override
            public REST.Response executeMethod(REST.Method method, Headers headers, String[] urlParams, UniNode body) {
                return this.handler.executeMethod(method, headers, urlParams, body);
            }
        }
    }
}

