/*
 * Decompiled with CFR 0.152.
 */
package org.comroid.restless.server;

import com.google.common.flogger.FluentLogger;
import com.google.common.flogger.LazyArgs;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.comroid.mutatio.span.Span;
import org.comroid.restless.HTTPStatusCodes;
import org.comroid.restless.REST;
import org.comroid.restless.server.RestEndpointException;
import org.comroid.restless.server.ServerEndpoint;
import org.comroid.uniform.ValueType;
import org.comroid.uniform.node.UniNode;
import org.comroid.uniform.node.UniObjectNode;

public class RestServer
implements Closeable {
    private static final REST.Response dummyResponse = new REST.Response(0, null);
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private final AutoContextHandler autoContextHandler = new AutoContextHandler();
    private final HttpServer server;
    private final Span<ServerEndpoint> endpoints;
    private final REST rest;
    private final String mimeType;
    private final String baseUrl;
    private final REST.Header.List commonHeaders = new REST.Header.List();

    public RestServer(REST rest, String baseUrl, InetAddress address, int port, ServerEndpoint ... endpoints) throws IOException {
        logger.at(Level.INFO).log("Starting REST Server with %d endpoints", endpoints.length);
        this.rest = rest;
        this.mimeType = rest.getSerializationAdapter().getMimeType();
        this.baseUrl = baseUrl;
        this.server = HttpServer.create(new InetSocketAddress(address, port), port);
        this.endpoints = Span.immutable((Object[])endpoints);
        this.server.createContext("/", this.autoContextHandler);
        this.server.setExecutor(rest.getExecutor());
        this.server.start();
    }

    public RestServer addCommonHeader(String name, String value) {
        this.commonHeaders.add(name, value);
        return this;
    }

    public boolean removeCommonHeader(String name) {
        return this.commonHeaders.removeIf(header -> header.getName().equals(name));
    }

    @Override
    public void close() {
        this.server.stop(5);
    }

    private class AutoContextHandler
    implements HttpHandler {
        private AutoContextHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(HttpExchange exchange) {
            String requestURI = RestServer.this.baseUrl.substring(0, RestServer.this.baseUrl.length() - 1) + exchange.getRequestURI().toString();
            REST.Method requestMethod = REST.Method.valueOf(exchange.getRequestMethod());
            String requestString = String.format("%s @ %s", new Object[]{requestMethod, requestURI});
            try {
                try {
                    Headers responseHeaders = exchange.getResponseHeaders();
                    Headers requestHeaders = exchange.getRequestHeaders();
                    RestServer.this.commonHeaders.forEach(responseHeaders::add);
                    responseHeaders.add("Accept", RestServer.this.mimeType);
                    responseHeaders.add("Content-Type", RestServer.this.mimeType);
                    if (RestServer.this.commonHeaders.stream().noneMatch(header -> header.getName().equals("Cookie")) && requestHeaders.containsKey("Cookie")) {
                        responseHeaders.add("Cookie", requestHeaders.getFirst("Cookie"));
                    }
                    logger.at(Level.INFO).log("Handling %s Request @ %s with Headers: %s", (Object)requestMethod, (Object)requestURI, (Object)LazyArgs.lazy(() -> requestHeaders.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals("Authorization")).map(entry -> String.format("%s: %s", entry.getKey(), Arrays.toString(((List)entry.getValue()).toArray()))).collect(Collectors.joining("\n- ", "\n- ", ""))));
                    String mimeType = RestServer.this.rest.getSerializationAdapter().getMimeType();
                    Object targetMimes = requestHeaders.get("Accept");
                    if (!this.supportedMimeType((List<String>)(targetMimes == null ? new ArrayList() : targetMimes))) {
                        logger.at(Level.INFO).log("Content Type %s not supported, cancelling. Accept Header: %s", (Object)mimeType, targetMimes);
                        throw new RestEndpointException(415, String.format("Content Type %s not supported, cancelling. Accept Header: %s", mimeType, targetMimes));
                    }
                    UniNode node = this.consumeBody(exchange);
                    logger.at(Level.INFO).log("Looking for matching endpoint...");
                    this.forwardToEndpoint(exchange, requestURI, requestMethod, responseHeaders, requestHeaders, node);
                }
                catch (Throwable t) {
                    if (t instanceof RestEndpointException) {
                        throw (RestEndpointException)t;
                    }
                    throw new RestEndpointException(500, t);
                }
            }
            catch (RestEndpointException reex) {
                ((FluentLogger.Api)logger.at(Level.INFO).withCause((Throwable)reex)).log("An endpoint exception occurred: " + reex.getMessage());
                String rsp = this.generateErrorNode(reex).toString();
                try {
                    this.writeResponse(exchange, reex.getStatusCode(), rsp);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            finally {
                exchange.close();
                logger.at(Level.INFO).log("Finished handling %s", (Object)requestString);
            }
        }

        private void forwardToEndpoint(HttpExchange exchange, String requestURI, REST.Method requestMethod, Headers responseHeaders, Headers requestHeaders, UniNode requestBody) throws RestEndpointException, IOException {
            Span.Iterator iter = RestServer.this.endpoints.pipe().filter(endpoint -> endpoint.test(requestURI)).sorted(Comparator.comparingInt(endpoint -> endpoint.isMemberAccess(requestURI) ? 1 : -1)).span().iterator();
            RestEndpointException lastException = null;
            REST.Response response = dummyResponse;
            if (!iter.hasNext()) {
                logger.at(Level.INFO).log("No endpoints found; returning 404");
                throw new RestEndpointException(404, "No endpoint found at URL: " + requestURI);
            }
            while (iter.hasNext()) {
                ServerEndpoint endpoint2 = (ServerEndpoint)iter.next();
                if (!endpoint2.supports(requestMethod)) continue;
                Object[] args = endpoint2.extractArgs(requestURI);
                logger.at(Level.INFO).log("Extracted parameters: %s", (Object)Arrays.toString(args));
                if (args.length != endpoint2.getParameterCount() && !endpoint2.allowMemberAccess()) {
                    throw new RestEndpointException(400, "Invalid argument Count");
                }
                try {
                    logger.at(Level.INFO).log("Executing Handler for method: %s", (Object)requestMethod);
                    response = endpoint2.executeMethod(requestMethod, requestHeaders, (String[])args, requestBody);
                }
                catch (RestEndpointException reex) {
                    lastException = reex;
                }
                if (response == dummyResponse) {
                    logger.at(Level.INFO).log("Handler could not complete normally, attempting next handler...", (Object)response);
                    continue;
                }
                logger.at(Level.INFO).log("Handler Finished! Response: %s", (Object)response);
                this.handleResponse(exchange, requestURI, endpoint2, responseHeaders, response);
                lastException = null;
                break;
            }
            if (lastException != null) {
                throw lastException;
            }
        }

        private void handleResponse(HttpExchange exchange, String requestURI, ServerEndpoint sep, Headers responseHeaders, REST.Response response) throws IOException {
            if (response == null) {
                this.writeResponse(exchange, 200);
                return;
            }
            response.getHeaders().forEach(responseHeaders::add);
            UniNode responseBody = response.getBody();
            String data = this.unwrapData(sep, requestURI, responseBody);
            this.writeResponse(exchange, response.getStatusCode(), data);
            logger.at(Level.INFO).log("Sent Response code %d with length %d and Headers: %s", (Object)response.getStatusCode(), (Object)data.length(), (Object)LazyArgs.lazy(() -> responseHeaders.entrySet().stream().map(entry -> String.format("%s: %s", entry.getKey(), Arrays.toString(((List)entry.getValue()).toArray()))).collect(Collectors.joining("\n- ", "\n- ", ""))));
        }

        private String unwrapData(ServerEndpoint sep, String requestURI, UniNode responseBody) {
            if (responseBody == null) {
                return "";
            }
            if (!sep.allowMemberAccess() || !sep.isMemberAccess(requestURI)) {
                return responseBody.toString();
            }
            String fractalName = requestURI.substring(requestURI.lastIndexOf("/") + 1);
            if (fractalName.matches("\\d+")) {
                int fractalNum = Integer.parseInt(fractalName);
                if (!responseBody.has(fractalNum)) {
                    fractalName = null;
                }
                if (fractalName != null) {
                    return responseBody.get(fractalNum).toString();
                }
            } else {
                if (!responseBody.has(fractalName)) {
                    fractalName = null;
                }
                if (fractalName != null) {
                    return responseBody.get(fractalName).toString();
                }
            }
            return responseBody.toString();
        }

        private void writeResponse(HttpExchange exchange, int statusCode) throws IOException {
            this.writeResponse(exchange, statusCode, "");
        }

        private void writeResponse(HttpExchange exchange, int statusCode, String data) throws IOException {
            exchange.sendResponseHeaders(statusCode, data.length());
            OutputStream osr = exchange.getResponseBody();
            osr.write(data.getBytes());
            osr.flush();
        }

        private UniObjectNode generateErrorNode(RestEndpointException reex) {
            UniObjectNode rsp = RestServer.this.rest.getSerializationAdapter().createUniObjectNode();
            rsp.put("code", ValueType.INTEGER, (Object)reex.getStatusCode());
            rsp.put("description", ValueType.STRING, (Object)HTTPStatusCodes.toString(reex.getStatusCode()));
            rsp.put("message", ValueType.STRING, (Object)reex.getSimpleMessage());
            Throwable cause = reex.getCause();
            if (cause != null) {
                rsp.put("cause", ValueType.STRING, (Object)cause.toString());
            }
            return rsp;
        }

        /*
         * Enabled aggressive exception aggregation
         */
        private UniNode consumeBody(HttpExchange exchange) {
            try (InputStreamReader isr = new InputStreamReader(exchange.getRequestBody());){
                String data;
                BufferedReader br;
                block14: {
                    UniObjectNode uniObjectNode;
                    br = new BufferedReader(isr);
                    try {
                        data = br.lines().collect(Collectors.joining());
                        if (!data.isEmpty()) break block14;
                        uniObjectNode = RestServer.this.rest.getSerializationAdapter().createUniObjectNode();
                    }
                    catch (Throwable throwable) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    br.close();
                    return uniObjectNode;
                }
                UniNode uniNode = RestServer.this.rest.getSerializationAdapter().createUniNode((Object)data);
                br.close();
                return uniNode;
            }
            catch (Throwable t) {
                logger.at(Level.SEVERE).log("Could not deserialize response");
                return null;
            }
        }

        private boolean supportedMimeType(List<String> targetMimes) {
            return targetMimes.isEmpty() || targetMimes.stream().anyMatch(type -> type.contains(RestServer.this.mimeType) || type.contains("*/*"));
        }
    }
}

