/*
 * Decompiled with CFR 0.152.
 */
package org.comroid.restless.server;

import com.google.common.flogger.FluentLogger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.stream.Stream;
import org.comroid.mutatio.span.Span;
import org.comroid.restless.REST;
import org.comroid.restless.endpoint.RatelimitedEndpoint;

public interface Ratelimiter
extends BiFunction<RatelimitedEndpoint, REST.Request, CompletableFuture<REST.Request>> {
    public static final FluentLogger logger = FluentLogger.forEnclosingClass();
    public static final Ratelimiter INSTANT = new Support.Instant();

    public static Ratelimiter ofPool(ScheduledExecutorService executor, RatelimitedEndpoint ... endpoints) {
        return new Support.OfPool(executor, endpoints);
    }

    public static int calculateOffset(int rps, int size) {
        return size / rps * 1000 + size % rps * (1000 / rps);
    }

    @Override
    public CompletableFuture<REST.Request> apply(RatelimitedEndpoint var1, REST.Request var2);

    public static final class Support {

        private static final class BoxedRequest {
            private final CompletableFuture<REST.Request> future = new CompletableFuture();
            private final REST.Request request;

            private BoxedRequest(REST.Request request) {
                this.request = request;
            }

            private void complete() {
                this.future.complete(this.request);
            }
        }

        private static final class OfPool
        implements Ratelimiter {
            private final Map<RatelimitedEndpoint, Queue<BoxedRequest>> upcoming = new ConcurrentHashMap<RatelimitedEndpoint, Queue<BoxedRequest>>();
            private final ScheduledExecutorService executor;
            private final RatelimitedEndpoint[] pool;
            private final int globalRatelimit;

            private OfPool(ScheduledExecutorService executor, RatelimitedEndpoint[] pool) {
                Span globalRatelimits = (Span)Stream.of(pool).map(RatelimitedEndpoint::getGlobalRatelimit).distinct().collect(Span.collector());
                if (!globalRatelimits.isSingle()) {
                    throw new IllegalArgumentException("Global ratelimit is not unique");
                }
                this.executor = executor;
                this.pool = pool;
                this.globalRatelimit = (Integer)globalRatelimits.requireNonNull();
            }

            @Override
            public synchronized CompletableFuture<REST.Request> apply(RatelimitedEndpoint restEndpoint, REST.Request request) {
                if (Arrays.stream(this.pool).noneMatch(restEndpoint::equals)) {
                    throw new IllegalArgumentException("Given endpoint is not part of pool");
                }
                int rps = restEndpoint.getRatePerSecond();
                Queue<BoxedRequest> queue = this.queueOf(restEndpoint);
                if (queue.isEmpty() || rps == -1 && restEndpoint.getGlobalRatelimit() == -1) {
                    return CompletableFuture.completedFuture(request);
                }
                return CompletableFuture.supplyAsync(() -> {
                    BoxedRequest boxed = new BoxedRequest(request);
                    Queue queue2 = queue;
                    synchronized (queue2) {
                        int sendInMs = Ratelimiter.calculateOffset(rps, queue.size()) + Ratelimiter.calculateOffset(this.globalRatelimit, this.currentQueueSize());
                        logger.at(Level.FINE).log("Calculated execution offset of %dms for %s", (Object)request);
                        queue.add(boxed);
                        this.executor.schedule(() -> {
                            boxed.complete();
                            if (!queue.remove(boxed)) {
                                throw new RuntimeException("Could not remove BoxedRequest from Queue!");
                            }
                        }, (long)sendInMs, TimeUnit.MILLISECONDS);
                    }
                    return boxed;
                }).thenCompose(boxed -> ((BoxedRequest)boxed).future);
            }

            private Queue<BoxedRequest> queueOf(RatelimitedEndpoint endpoint) {
                return this.upcoming.computeIfAbsent(endpoint, key -> new LinkedBlockingQueue());
            }

            private int currentQueueSize() {
                return this.upcoming.values().stream().mapToInt(Collection::size).sum();
            }
        }

        private static final class Instant
        implements Ratelimiter {
            private Instant() {
            }

            @Override
            public CompletableFuture<REST.Request> apply(RatelimitedEndpoint restEndpoint, REST.Request request) {
                return CompletableFuture.completedFuture(request);
            }
        }
    }
}

