/*
 * Decompiled with CFR 0.152.
 */
package org.comroid.restless.server;

import com.sun.net.httpserver.Headers;
import org.comroid.restless.REST;
import org.comroid.restless.server.RestEndpointException;
import org.comroid.uniform.node.UniNode;
import org.jetbrains.annotations.ApiStatus;

public interface EndpointHandler {
    default public boolean supports(REST.Method method) {
        switch (method) {
            case GET: {
                return this.isReimplemented("executeGET");
            }
            case PUT: {
                return this.isReimplemented("executePUT");
            }
            case POST: {
                return this.isReimplemented("executePOST");
            }
            case PATCH: {
                return this.isReimplemented("executePATCH");
            }
            case DELETE: {
                return this.isReimplemented("executeDELETE");
            }
            case HEAD: {
                return this.isReimplemented("executeHEAD");
            }
        }
        throw new AssertionError((Object)("No such method: " + (Object)((Object)method)));
    }

    default public REST.Response executeMethod(REST.Method method, Headers headers, String[] urlParams, UniNode body) throws RestEndpointException {
        switch (method) {
            case GET: {
                return this.executeGET(headers, urlParams, body);
            }
            case PUT: {
                return this.executePUT(headers, urlParams, body);
            }
            case POST: {
                return this.executePOST(headers, urlParams, body);
            }
            case PATCH: {
                return this.executePATCH(headers, urlParams, body);
            }
            case DELETE: {
                return this.executeDELETE(headers, urlParams, body);
            }
            case HEAD: {
                return this.executeHEAD(headers, urlParams, body);
            }
        }
        throw new AssertionError((Object)("No such method: " + (Object)((Object)method)));
    }

    default public REST.Response executeGET(Headers headers, String[] urlParams, UniNode body) throws RestEndpointException {
        throw new RestEndpointException(405, "Method not supported: GET");
    }

    default public REST.Response executePUT(Headers headers, String[] urlParams, UniNode body) throws RestEndpointException {
        throw new RestEndpointException(405, "Method not supported: PUT");
    }

    default public REST.Response executePOST(Headers headers, String[] urlParams, UniNode body) throws RestEndpointException {
        throw new RestEndpointException(405, "Method not supported: POST");
    }

    default public REST.Response executePATCH(Headers headers, String[] urlParams, UniNode body) throws RestEndpointException {
        throw new RestEndpointException(405, "Method not supported: PATCH");
    }

    default public REST.Response executeDELETE(Headers headers, String[] urlParams, UniNode body) throws RestEndpointException {
        throw new RestEndpointException(405, "Method not supported: DELETE");
    }

    default public REST.Response executeHEAD(Headers headers, String[] urlParams, UniNode body) throws RestEndpointException {
        throw new RestEndpointException(405, "Method not supported: HEAD");
    }

    @ApiStatus.Internal
    default public boolean isReimplemented(String methodName) {
        try {
            return !this.getClass().getMethod(methodName, Headers.class, String[].class, UniNode.class).getDeclaringClass().equals(EndpointHandler.class);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }
}

