/*
 * Decompiled with CFR 0.152.
 */
package org.comroid.restless.endpoint;

import java.net.URI;
import java.net.URL;
import org.comroid.api.Polyfill;
import org.comroid.restless.endpoint.AccessibleEndpoint;

public interface CompleteEndpoint {
    public AccessibleEndpoint getEndpoint();

    public String getSpec();

    default public URL getURL() {
        return Polyfill.url((String)this.getSpec());
    }

    default public URI getURI() {
        return Polyfill.uri((String)this.getSpec());
    }

    public static CompleteEndpoint of(AccessibleEndpoint endpoint, String spec) {
        return new Support.OfSpec(endpoint, spec);
    }

    public static final class Support {

        private static final class OfSpec
        implements CompleteEndpoint {
            private final AccessibleEndpoint endpoint;
            private final String spec;

            @Override
            public AccessibleEndpoint getEndpoint() {
                return this.endpoint;
            }

            @Override
            public String getSpec() {
                return this.spec;
            }

            private OfSpec(AccessibleEndpoint endpoint, String spec) {
                this.endpoint = endpoint;
                this.spec = spec;
            }
        }
    }
}

