/*
 * Decompiled with CFR 0.152.
 */
package org.comroid.restless.endpoint;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.comroid.api.Polyfill;
import org.comroid.common.ref.StaticCache;
import org.comroid.restless.endpoint.CompleteEndpoint;
import org.comroid.restless.endpoint.RatelimitedEndpoint;
import org.comroid.restless.server.EndpointHandler;
import org.comroid.restless.server.ServerEndpoint;
import org.jetbrains.annotations.ApiStatus;

public interface AccessibleEndpoint
extends RatelimitedEndpoint,
Predicate<String> {
    public String getUrlBase();

    public String getUrlExtension();

    public String[] getRegExpGroups();

    default public Pattern getPattern() {
        return (Pattern)StaticCache.access((Object)this, (String)"pattern", this::buildUrlPattern);
    }

    default public int getParameterCount() {
        return this.getRegExpGroups().length;
    }

    default public String getFullUrl() {
        return this.getUrlBase() + this.getUrlExtension();
    }

    @Override
    default public int getRatePerSecond() {
        return -1;
    }

    @Override
    default public int getGlobalRatelimit() {
        return -1;
    }

    default public CompleteEndpoint complete(Object ... args) throws IllegalArgumentException {
        return CompleteEndpoint.of(this, this.string(args));
    }

    default public String string(Object ... args) throws IllegalArgumentException {
        if (args.length != this.getParameterCount()) {
            throw new IllegalArgumentException("Invalid argument count");
        }
        String format = String.format(this.getFullUrl(), args);
        if (this.test(format)) {
            return format;
        }
        throw new IllegalArgumentException("Generated spec is invalid");
    }

    default public URL url(Object ... args) throws IllegalArgumentException {
        return Polyfill.url((String)this.string(args));
    }

    default public URI uri(Object ... args) throws IllegalArgumentException {
        return Polyfill.uri((String)this.string(args));
    }

    @Override
    default public boolean test(URL url) {
        return this.test(url.toExternalForm());
    }

    @Override
    default public boolean test(URI uri) {
        return this.test(uri.toString());
    }

    @Override
    default public boolean test(String url) {
        if (this instanceof ServerEndpoint && ((ServerEndpoint)this).allowMemberAccess() && ((ServerEndpoint)this).isMemberAccess(url)) {
            url = url.substring(0, url.lastIndexOf("/"));
        }
        String[] regExpGroups = this.getRegExpGroups();
        String replacer = this.replacer(regExpGroups);
        if (regExpGroups.length == 0) {
            return replacer.equals(url);
        }
        return this.getPattern().matcher(url).replaceAll(replacer).equals(url);
    }

    default public String[] extractArgs(URL url) {
        return this.extractArgs(url.toExternalForm());
    }

    default public String[] extractArgs(URI uri) {
        return this.extractArgs(uri.toString());
    }

    default public String[] extractArgs(String requestUrl) {
        if (this instanceof ServerEndpoint && ((ServerEndpoint)this).allowMemberAccess() && ((ServerEndpoint)this).isMemberAccess(requestUrl)) {
            requestUrl = requestUrl.substring(0, requestUrl.lastIndexOf("/"));
        }
        Matcher matcher = this.getPattern().matcher(requestUrl);
        String[] groups = this.getRegExpGroups();
        if (matcher.matches() && this.test(requestUrl)) {
            ArrayList<String> yields = new ArrayList<String>();
            int i = 1;
            while (groups.length + 1 > i && matcher.matches()) {
                yields.add(matcher.group(i++));
            }
            return yields.toArray(new String[0]);
        }
        return new String[0];
    }

    @ApiStatus.Internal
    default public String replacer(String[] groups) {
        return (String)StaticCache.access((Object)this, (String)"replacer", () -> {
            String yield = this.getFullUrl();
            int i = 0;
            while (yield.contains("%s") && groups.length > i) {
                int fi = yield.indexOf("%s");
                yield = String.format("%s$%d%s", yield.substring(0, fi), ++i, yield.substring(fi + 2));
            }
            return yield;
        });
    }

    default public Pattern buildUrlPattern() {
        String[] regExpGroups = this.getRegExpGroups();
        if (regExpGroups != null && regExpGroups.length > 0) {
            return Pattern.compile(String.format(this.getFullUrl(), Arrays.stream(regExpGroups).map(str -> String.format("(%s)", str)).toArray()));
        }
        return Pattern.compile(this.getFullUrl().replace("%s", "(.*)"));
    }

    default public ServerEndpoint attachHandler(EndpointHandler handler) {
        return ServerEndpoint.combined(this, handler);
    }
}

