/*
 * Decompiled with CFR 0.152.
 */
package org.comroid.restless.adapter.okhttp.v4;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.comroid.restless.HttpAdapter;
import org.comroid.restless.REST;

public class OkHttp3Adapter
implements HttpAdapter {
    private final OkHttpClient httpClient = new OkHttpClient.Builder().build();

    @Override
    public CompletableFuture<REST.Response> call(REST.Request request, String mimeType) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                REST.Method requestMethod = request.getMethod();
                String requestBody = request.getBody();
                Request.Builder builder = new Request.Builder().url(request.getEndpoint().getURL()).method(requestMethod.toString(), requestBody == null && requestMethod == REST.Method.GET ? null : RequestBody.create((MediaType)MediaType.parse((String)mimeType), (String)Objects.requireNonNull(requestBody, "Null body not supported with " + (Object)((Object)requestMethod))));
                request.getHeaders().forEach(header -> builder.addHeader(header.getName(), header.getValue()));
                Request kRequest = builder.build();
                Call call = this.httpClient.newCall(kRequest);
                Response response = call.execute();
                ResponseBody responseBody = response.body();
                return new REST.Response(response.code(), request.getREST().getSerializationAdapter().createUniNode((Object)(responseBody == null ? null : responseBody.string())));
            }
            catch (IOException e) {
                throw new RuntimeException("Request failed", e);
            }
        });
    }
}

