/*
 * Decompiled with CFR 0.152.
 */
package org.comroid.restless.adapter.jdk;

import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import org.comroid.restless.HttpAdapter;
import org.comroid.restless.REST;
import org.comroid.uniform.node.UniNode;

public final class JavaHttpAdapter
implements HttpAdapter {
    private final HttpClient httpClient = HttpClient.newBuilder().build();

    @Override
    public CompletableFuture<REST.Response> call(REST.Request request, String mimeType) {
        HttpRequest.Builder builder = HttpRequest.newBuilder(request.getEndpoint().getURI()).header("Content-Type", mimeType);
        request.getHeaders().forEach(builder::header);
        HttpRequest.BodyPublisher publisher = request.getMethod() == REST.Method.GET ? HttpRequest.BodyPublishers.noBody() : HttpRequest.BodyPublishers.ofString(request.getBody(), StandardCharsets.UTF_8);
        return this.httpClient.sendAsync(builder.build(), HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8)).thenApply(response -> {
            String body = (String)response.body();
            if (body == null) {
                return new REST.Response(response.statusCode(), null);
            }
            UniNode data = request.getREST().getSerializationAdapter().createUniNode((Object)body);
            return new REST.Response(response.statusCode(), data);
        });
    }
}

