/*
 * Decompiled with CFR 0.152.
 */
package org.comroid.restless;

import com.google.common.flogger.FluentLogger;
import com.sun.net.httpserver.Headers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import org.comroid.api.Invocable;
import org.comroid.api.Polyfill;
import org.comroid.mutatio.span.Span;
import org.comroid.restless.HttpAdapter;
import org.comroid.restless.endpoint.AccessibleEndpoint;
import org.comroid.restless.endpoint.CompleteEndpoint;
import org.comroid.restless.endpoint.RatelimitedEndpoint;
import org.comroid.restless.server.Ratelimiter;
import org.comroid.uniform.SerializationAdapter;
import org.comroid.uniform.cache.Cache;
import org.comroid.uniform.node.UniNode;
import org.comroid.uniform.node.UniObjectNode;
import org.comroid.varbind.bind.GroupBind;
import org.comroid.varbind.bind.VarBind;
import org.comroid.varbind.container.DataContainer;
import org.comroid.varbind.container.DataContainerBase;
import org.jetbrains.annotations.Nullable;

public final class REST<D> {
    public static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private final HttpAdapter httpAdapter;
    private final SerializationAdapter<?, ?, ?> serializationAdapter;
    private final Ratelimiter ratelimiter;
    @Nullable
    private final D dependencyObject;
    private final Executor executor;

    public HttpAdapter getHttpAdapter() {
        return this.httpAdapter;
    }

    public SerializationAdapter<?, ?, ?> getSerializationAdapter() {
        return this.serializationAdapter;
    }

    public Ratelimiter getRatelimiter() {
        return this.ratelimiter;
    }

    public Optional<D> getDependencyObject() {
        return Optional.ofNullable(this.dependencyObject);
    }

    public final Executor getExecutor() {
        return this.executor;
    }

    public REST(HttpAdapter httpAdapter, SerializationAdapter<?, ?, ?> serializationAdapter) {
        this(httpAdapter, serializationAdapter, ForkJoinPool.commonPool(), null);
    }

    public REST(HttpAdapter httpAdapter, SerializationAdapter<?, ?, ?> serializationAdapter, @Nullable D dependencyObject) {
        this(httpAdapter, serializationAdapter, ForkJoinPool.commonPool(), dependencyObject);
    }

    public REST(HttpAdapter httpAdapter, SerializationAdapter<?, ?, ?> serializationAdapter, Executor requestExecutor, @Nullable D dependencyObject) {
        this(httpAdapter, serializationAdapter, requestExecutor, Ratelimiter.INSTANT, dependencyObject);
    }

    public REST(HttpAdapter httpAdapter, SerializationAdapter<?, ?, ?> serializationAdapter, ScheduledExecutorService scheduledExecutorService, @Nullable D dependencyObject, RatelimitedEndpoint ... pool) {
        this(httpAdapter, serializationAdapter, (Executor)scheduledExecutorService, Ratelimiter.ofPool(scheduledExecutorService, pool), dependencyObject);
    }

    public REST(HttpAdapter httpAdapter, SerializationAdapter<?, ?, ?> serializationAdapter, Executor requestExecutor, Ratelimiter ratelimiter, @Nullable D dependencyObject) {
        this.httpAdapter = Objects.requireNonNull(httpAdapter, "HttpAdapter");
        this.serializationAdapter = Objects.requireNonNull(serializationAdapter, "SerializationAdapter");
        this.executor = Objects.requireNonNull(requestExecutor, "RequestExecutor");
        this.ratelimiter = Objects.requireNonNull(ratelimiter, "Ratelimiter");
        this.dependencyObject = dependencyObject;
    }

    public Request<UniObjectNode> request() {
        return new Request<UniObjectNode>(Invocable.paramReturning(UniObjectNode.class));
    }

    public <T extends DataContainer<? extends D>> Request<T> request(Class<T> type) {
        return this.request(DataContainerBase.findRootBind(type));
    }

    public <T extends DataContainer<? extends D>> Request<T> request(GroupBind<T, D> group) {
        return this.request((Invocable)Polyfill.uncheckedCast(group.getConstructor().orElseThrow(() -> new NoSuchElementException("No constructor applied to GroupBind"))));
    }

    public <T> Request<T> request(Invocable<T> creator) {
        return new Request<T>(creator);
    }

    public final class Request<T> {
        private final Header.List headers;
        private final Invocable<T> tProducer;
        private final CompletableFuture<Response> execution = new CompletableFuture();
        private CompleteEndpoint endpoint;
        private Method method;
        private String body;
        private int expectedCode = 200;

        public final CompleteEndpoint getEndpoint() {
            return this.endpoint;
        }

        public final Method getMethod() {
            return this.method;
        }

        public final String getBody() {
            return this.body;
        }

        public final Header.List getHeaders() {
            return this.headers;
        }

        public REST<D> getREST() {
            return REST.this;
        }

        public Request(Invocable<T> tProducer) {
            this.tProducer = tProducer;
            this.headers = new Header.List();
        }

        public String toString() {
            return String.format("%s @ %s", this.method.name(), this.endpoint.getSpec());
        }

        public final Request<T> expect(int code) {
            this.expectedCode = code;
            return this;
        }

        public final Request<T> endpoint(CompleteEndpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final Request<T> endpoint(AccessibleEndpoint endpoint, Object ... args) {
            return this.endpoint(endpoint.complete(args));
        }

        public final Request<T> method(Method method) {
            this.method = method;
            return this;
        }

        public final Request<T> body(String body) {
            this.body = body;
            return this;
        }

        public final Request<T> addHeader(String name, String value) {
            this.headers.add(new Header(name, value));
            return this;
        }

        public final boolean removeHeaders(Predicate<Header> filter) {
            return this.headers.removeIf(filter);
        }

        public final synchronized CompletableFuture<Response> execute() {
            if (!this.execution.isDone()) {
                logger.at(Level.FINE).log("Executing request %s @ %s");
                ((CompletableFuture)this.getREST().ratelimiter.apply(this.endpoint.getEndpoint(), this).thenCompose(request -> REST.this.httpAdapter.call((Request)request, REST.this.serializationAdapter.getMimeType()))).thenAcceptAsync(response -> {
                    if (((Response)response).statusCode != this.expectedCode) {
                        logger.at(Level.WARNING).log("Unexpected Response status code %d; expected %d", ((Response)response).statusCode, this.expectedCode);
                    }
                    this.execution.complete((Response)response);
                }, REST.this.executor);
            }
            return this.execution;
        }

        public final CompletableFuture<Integer> execute$statusCode() {
            return this.execute().thenApply(Response::getStatusCode);
        }

        public final CompletableFuture<UniNode> execute$body() {
            return this.execute().thenApply(Response::getBody);
        }

        public final CompletableFuture<Span<T>> execute$deserialize() {
            return this.execute$body().thenApply(node -> {
                switch (node.getType()) {
                    case OBJECT: {
                        return Span.singleton((Object)this.tProducer.autoInvoke(new Object[]{REST.this.dependencyObject, node.asObjectNode()}));
                    }
                    case ARRAY: {
                        return (Span)node.asArrayNode().asNodeList().stream().map(UniNode::asObjectNode).map(sub -> this.tProducer.autoInvoke(new Object[]{REST.this.dependencyObject, sub})).collect(Span.collector());
                    }
                    case VALUE: {
                        throw new AssertionError((Object)"Cannot deserialize from UniValueNode");
                    }
                }
                throw new AssertionError();
            });
        }

        public final CompletableFuture<T> execute$deserializeSingle() {
            return this.execute$deserialize().thenApply(Span::requireNonNull);
        }

        public final <R> CompletableFuture<Span<R>> execute$map(Function<T, R> remapper) {
            return this.execute$deserialize().thenApply(span -> (Span)span.stream().map(remapper).collect(Span.collector()));
        }

        public final <R> CompletableFuture<R> execute$mapSingle(Function<T, R> remapper) {
            return this.execute$deserialize().thenApply(span -> {
                if (!span.isSingle()) {
                    throw new IllegalArgumentException("Span too large");
                }
                return remapper.apply(span.get());
            });
        }

        public final <ID> CompletableFuture<Span<T>> execute$autoCache(VarBind<?, ? super D, ?, ID> identifyBind, Cache<ID, ? super T> cache) {
            return this.execute$body().thenApply(node -> {
                if (node.isObjectNode()) {
                    return Span.singleton(this.cacheProduce(identifyBind, cache, node.asObjectNode()));
                }
                if (node.isArrayNode()) {
                    return (Span)node.asNodeList().stream().map(UniNode::asObjectNode).map(obj -> this.cacheProduce(identifyBind, cache, (UniObjectNode)obj)).collect(Span.collector());
                }
                throw new AssertionError();
            });
        }

        private <ID> T cacheProduce(VarBind<?, ? super D, ?, ID> identifyBind, Cache<ID, ? super T> cache, UniObjectNode obj) {
            Object id = identifyBind.getFrom(obj);
            if (id == null) {
                throw new IllegalArgumentException("Invalid Data: Could not resolve identifying Bind");
            }
            if (cache.containsKey(id)) {
                cache.getReference(id, false).compute(old -> ((DataContainer)Objects.requireNonNull(old, "Assert failed: Cache did not contain object")).updateFrom(obj));
            } else {
                cache.getReference(id, true).set(this.tProducer.autoInvoke(new Object[]{REST.this.dependencyObject, obj}));
            }
            return (T)cache.requireNonNull(id, "Assert failed: Cache is still missing key " + id);
        }
    }

    public static class Response {
        private final int statusCode;
        private final UniNode body;
        private final Header.List headers = new Header.List();

        public int getStatusCode() {
            return this.statusCode;
        }

        public UniNode getBody() {
            return this.body;
        }

        public Header.List getHeaders() {
            return this.headers;
        }

        public Response(int statusCode, UniNode body) {
            this.statusCode = statusCode;
            this.body = body;
        }

        public Response(REST rest, int statusCode, String body) {
            this(statusCode, rest.serializationAdapter.createUniNode((Object)body));
        }

        public static Response empty(SerializationAdapter seriLib, int code) {
            return new Response(code, seriLib.createUniNode(null));
        }
    }

    public static final class Header {
        private final String name;
        private final String value;

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public Header(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public static final class List
        extends ArrayList<Header> {
            public static List of(Headers headers) {
                List list = new List();
                headers.forEach((? super K name, ? super V values) -> list.add((String)name, values.size() == 1 ? (String)values.get(0) : Arrays.toString(values.toArray())));
                return list;
            }

            public boolean add(String name, String value) {
                return super.add(new Header(name, value));
            }

            public boolean contains(String name) {
                return this.stream().anyMatch(it -> ((Header)it).name.equals(name));
            }

            public String get(String key) {
                return this.stream().filter(it -> ((Header)it).name.equals(key)).findAny().map(Header::getValue).orElse(null);
            }

            public void forEach(BiConsumer<String, String> action) {
                this.forEach((? super E header) -> action.accept(header.getName(), header.getValue()));
            }
        }
    }

    public static enum Method {
        GET,
        PUT,
        POST,
        PATCH,
        DELETE,
        HEAD;


        public String toString() {
            return this.name();
        }
    }
}

