/*
 * Decompiled with CFR 0.152.
 */
package org.comixedproject.model.user;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import lombok.Generated;
import org.comixedproject.model.user.ComiXedRole;
import org.comixedproject.model.user.Preference;
import org.comixedproject.views.View;

@Entity
@Table(name="ComiXedUsers")
public class ComiXedUser {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @JsonView(value={View.UserList.class})
    private Long id;
    @Column(name="Email", updatable=true, nullable=false, unique=true)
    @JsonView(value={View.UserList.class})
    private String email;
    @Transient
    @JsonIgnore
    private String password;
    @Column(name="PasswordHash", updatable=true, nullable=false)
    private String passwordHash;
    @Column(name="CreatedOn", nullable=false, updatable=false)
    @JsonProperty(value="first_login_date")
    @JsonView(value={View.UserList.class})
    private Date firstLoginDate = new Date();
    @Column(name="LastLoggedOn", nullable=false, updatable=true)
    @JsonProperty(value="last_login_date")
    @JsonView(value={View.UserList.class})
    private Date lastLoginDate = new Date();
    @ManyToMany
    @JoinTable(name="ComiXedUserRoles", joinColumns={@JoinColumn(name="ComiXedUserId")}, inverseJoinColumns={@JoinColumn(name="ComiXedRoleId")})
    @JsonView(value={View.UserList.class})
    private List<ComiXedRole> roles = new ArrayList<ComiXedRole>();
    @OneToMany(mappedBy="user", cascade={CascadeType.ALL}, fetch=FetchType.EAGER, orphanRemoval=true)
    @JsonView(value={View.UserList.class})
    private List<Preference> preferences = new ArrayList<Preference>();
    @Transient
    @JsonView(value={View.UserList.class})
    private boolean authenticated = false;

    public void addRole(ComiXedRole role) {
        if (!this.roles.contains(role)) {
            this.roles.add(role);
        }
    }

    public void setProperty(String name, String value) {
        for (Preference preference : this.preferences) {
            if (!preference.getName().equals(name)) continue;
            preference.setValue(value);
            return;
        }
        this.preferences.add(new Preference(this, name, value));
    }

    public void deleteProperty(String name) {
        Preference preference = null;
        int index = -1;
        for (int which = 0; which < this.preferences.size(); ++which) {
            if (!this.preferences.get(which).getName().equals(name)) continue;
            preference = this.preferences.get(which);
            index = which;
            break;
        }
        if (preference != null) {
            preference.setUser(null);
            this.preferences.remove(index);
        }
    }

    public void clearRoles() {
        this.roles.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComiXedUser that = (ComiXedUser)o;
        return Objects.equals(this.email, that.email);
    }

    public int hashCode() {
        return Objects.hash(this.email);
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @JsonView(value={View.UserList.class})
    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public String getPasswordHash() {
        return this.passwordHash;
    }

    @Generated
    public void setPasswordHash(String passwordHash) {
        this.passwordHash = passwordHash;
    }

    @Generated
    public Date getFirstLoginDate() {
        return this.firstLoginDate;
    }

    @Generated
    public Date getLastLoginDate() {
        return this.lastLoginDate;
    }

    @JsonProperty(value="last_login_date")
    @JsonView(value={View.UserList.class})
    @Generated
    public void setLastLoginDate(Date lastLoginDate) {
        this.lastLoginDate = lastLoginDate;
    }

    @Generated
    public List<ComiXedRole> getRoles() {
        return this.roles;
    }

    @Generated
    public List<Preference> getPreferences() {
        return this.preferences;
    }

    @Generated
    public boolean isAuthenticated() {
        return this.authenticated;
    }

    @JsonView(value={View.UserList.class})
    @Generated
    public void setAuthenticated(boolean authenticated) {
        this.authenticated = authenticated;
    }
}

