/*
 * Decompiled with CFR 0.152.
 */
package org.comixedproject.model.lists;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import lombok.Generated;
import lombok.NonNull;
import org.comixedproject.model.comicbooks.ComicBook;
import org.comixedproject.model.lists.Story;
import org.comixedproject.model.lists.StoryEntryState;
import org.comixedproject.views.View;

@Entity
@Table(name="StoryEntries")
public class StoryEntry {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @JsonProperty(value="id")
    @JsonView(value={View.StoryList.class})
    private Long id;
    @ManyToOne
    @JoinColumn(name="StoryId", nullable=false, updatable=false)
    @NonNull
    private Story story;
    @Column(name="StoryEntryState", nullable=false, updatable=true)
    @Enumerated(value=EnumType.STRING)
    @NonNull
    private StoryEntryState storyEntryState = StoryEntryState.DEFINED;
    @Column(name="ReadingOrder", nullable=false, updatable=false)
    @JsonProperty(value="readingOrder")
    @JsonView(value={View.StoryList.class})
    private int readingOrder;
    @Column(name="Series", length=128, nullable=false, updatable=true)
    @JsonProperty(value="series")
    @JsonView(value={View.StoryList.class})
    private String series;
    @Column(name="Volume", length=4, nullable=false, updatable=true)
    @JsonProperty(value="volume")
    @JsonView(value={View.StoryList.class})
    private String volume;
    @Column(name="IssueNumber", length=16, nullable=false, updatable=false)
    @JsonProperty(value="issueNumber")
    @JsonView(value={View.StoryList.class})
    private String issueNumber;
    @ManyToOne(cascade={CascadeType.DETACH})
    @JoinColumn(name="ComicBookId", nullable=true, updatable=false)
    @JsonView(value={View.StoryList.class})
    @JsonProperty(value="comicBook")
    private ComicBook comicBook;
    @Column(name="ComicVineId", nullable=true, updatable=true, unique=true)
    @JsonProperty(value="comicVineId")
    @JsonView(value={View.StoryList.class})
    private Integer comicVineId;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoryEntry that = (StoryEntry)o;
        return this.readingOrder == that.readingOrder && this.story.equals(that.story) && this.storyEntryState.equals((Object)that.storyEntryState) && this.series.equals(that.series) && this.volume.equals(that.volume) && this.issueNumber.equals(that.issueNumber);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.story, this.storyEntryState, this.readingOrder, this.series, this.volume, this.issueNumber});
    }

    @Generated
    public StoryEntry() {
    }

    @Generated
    public StoryEntry(@NonNull Story story) {
        if (story == null) {
            throw new NullPointerException("story is marked non-null but is null");
        }
        this.story = story;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @NonNull
    @Generated
    public Story getStory() {
        return this.story;
    }

    @NonNull
    @Generated
    public StoryEntryState getStoryEntryState() {
        return this.storyEntryState;
    }

    @Generated
    public void setStoryEntryState(@NonNull StoryEntryState storyEntryState) {
        if (storyEntryState == null) {
            throw new NullPointerException("storyEntryState is marked non-null but is null");
        }
        this.storyEntryState = storyEntryState;
    }

    @Generated
    public int getReadingOrder() {
        return this.readingOrder;
    }

    @Generated
    public String getSeries() {
        return this.series;
    }

    @JsonProperty(value="series")
    @JsonView(value={View.StoryList.class})
    @Generated
    public void setSeries(String series) {
        this.series = series;
    }

    @Generated
    public String getVolume() {
        return this.volume;
    }

    @JsonProperty(value="volume")
    @JsonView(value={View.StoryList.class})
    @Generated
    public void setVolume(String volume) {
        this.volume = volume;
    }

    @Generated
    public String getIssueNumber() {
        return this.issueNumber;
    }

    @JsonProperty(value="issueNumber")
    @JsonView(value={View.StoryList.class})
    @Generated
    public void setIssueNumber(String issueNumber) {
        this.issueNumber = issueNumber;
    }

    @Generated
    public ComicBook getComicBook() {
        return this.comicBook;
    }

    @JsonView(value={View.StoryList.class})
    @JsonProperty(value="comicBook")
    @Generated
    public void setComicBook(ComicBook comicBook) {
        this.comicBook = comicBook;
    }

    @Generated
    public Integer getComicVineId() {
        return this.comicVineId;
    }

    @JsonProperty(value="comicVineId")
    @JsonView(value={View.StoryList.class})
    @Generated
    public void setComicVineId(Integer comicVineId) {
        this.comicVineId = comicVineId;
    }
}

