/*
 * Decompiled with CFR 0.152.
 */
package org.comixedproject.model.lists;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import lombok.Generated;
import lombok.NonNull;
import org.comixedproject.model.lists.StoryEntry;
import org.comixedproject.model.lists.StoryState;
import org.comixedproject.views.View;

@Entity
@Table(name="Stories")
public class Story {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @JsonProperty(value="id")
    @JsonView(value={View.StoryList.class})
    private Long id;
    @Column(name="Name", length=256, nullable=false, updatable=false)
    @JsonProperty(value="name")
    @JsonView(value={View.StoryList.class})
    @NonNull
    private String name;
    @Column(name="ComicVineId", nullable=true, updatable=true, unique=true)
    @JsonProperty(value="comicVineId")
    @JsonView(value={View.StoryList.class})
    private Integer comicVineId;
    @Column(name="StoryState", nullable=false, updatable=true)
    @Enumerated(value=EnumType.STRING)
    @JsonIgnore
    private StoryState storyState = StoryState.CREATED;
    @Column(name="Publisher", length=128, nullable=false, updatable=false)
    @JsonProperty(value="publisher")
    @JsonView(value={View.StoryList.class})
    @NonNull
    String publisher;
    @OneToMany(mappedBy="story")
    @OrderColumn(name="ReadingOrder")
    @JsonProperty(value="entries")
    @JsonView(value={View.StoryList.class})
    private List<StoryEntry> entries = new ArrayList<StoryEntry>();
    @Column(name="CreatedOn", nullable=false, updatable=false)
    @JsonProperty(value="createdOn")
    @JsonFormat(shape=JsonFormat.Shape.NUMBER_INT)
    @JsonView(value={View.StoryList.class})
    private Date createdOn = new Date();
    @Column(name="ModifiedOn", nullable=false, updatable=true)
    @JsonProperty(value="modifiedOn")
    @JsonFormat(shape=JsonFormat.Shape.NUMBER_INT)
    @JsonView(value={View.StoryList.class})
    private Date modifiedOn = new Date();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Story story = (Story)o;
        return this.name.equals(story.name) && this.publisher.equals(story.publisher);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.publisher);
    }

    @Generated
    public Story() {
    }

    @Generated
    public Story(@NonNull String name, @NonNull String publisher) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (publisher == null) {
            throw new NullPointerException("publisher is marked non-null but is null");
        }
        this.name = name;
        this.publisher = publisher;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @NonNull
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getComicVineId() {
        return this.comicVineId;
    }

    @JsonProperty(value="comicVineId")
    @JsonView(value={View.StoryList.class})
    @Generated
    public void setComicVineId(Integer comicVineId) {
        this.comicVineId = comicVineId;
    }

    @Generated
    public StoryState getStoryState() {
        return this.storyState;
    }

    @JsonIgnore
    @Generated
    public void setStoryState(StoryState storyState) {
        this.storyState = storyState;
    }

    @NonNull
    @Generated
    public String getPublisher() {
        return this.publisher;
    }

    @JsonProperty(value="publisher")
    @JsonView(value={View.StoryList.class})
    @Generated
    public void setPublisher(@NonNull String publisher) {
        if (publisher == null) {
            throw new NullPointerException("publisher is marked non-null but is null");
        }
        this.publisher = publisher;
    }

    @Generated
    public List<StoryEntry> getEntries() {
        return this.entries;
    }

    @Generated
    public Date getCreatedOn() {
        return this.createdOn;
    }

    @Generated
    public Date getModifiedOn() {
        return this.modifiedOn;
    }

    @JsonProperty(value="modifiedOn")
    @JsonFormat(shape=JsonFormat.Shape.NUMBER_INT)
    @JsonView(value={View.StoryList.class})
    @Generated
    public void setModifiedOn(Date modifiedOn) {
        this.modifiedOn = modifiedOn;
    }
}

