/*
 * Decompiled with CFR 0.152.
 */
package org.comixedproject.model.library;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import lombok.Generated;
import lombok.NonNull;
import org.comixedproject.model.library.SmartReadingList;
import org.comixedproject.views.View;

@Entity
@Table(name="SmartListMatchers")
public class SmartListMatcher {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @JsonProperty(value="id")
    @JsonView(value={View.SmartReadingList.class})
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY, optional=true)
    @JoinColumn(name="SmartListId")
    @JsonIgnore
    @JsonView(value={View.SmartReadingList.class})
    @NonNull
    private SmartReadingList smartList;
    @Column(name="MatcherType", length=128)
    @JsonProperty(value="type")
    @JsonView(value={View.SmartReadingList.class})
    private String type;
    @Column(name="Negative")
    @JsonProperty(value="negative")
    @JsonView(value={View.SmartReadingList.class})
    private boolean not = false;
    @Column(name="MatcherMode")
    @JsonProperty(value="mode")
    @JsonView(value={View.SmartReadingList.class})
    private String mode;
    @Column(name="MatcherOperator")
    @JsonProperty(value="operator")
    @JsonView(value={View.SmartReadingList.class})
    private String operator;
    @Column(name="MatcherValue")
    @JsonProperty(value="value")
    @JsonView(value={View.SmartReadingList.class})
    private String value;
    @ManyToOne(fetch=FetchType.LAZY, optional=true)
    @JoinColumn(name="NextMatcherId")
    @JsonIgnore
    @JsonView(value={View.SmartReadingList.class})
    private SmartListMatcher nextMatcher;
    @OneToMany(mappedBy="nextMatcher", cascade={CascadeType.ALL}, fetch=FetchType.EAGER, orphanRemoval=true)
    @OrderColumn(name="id")
    @JsonProperty(value="matchers")
    @JsonView(value={View.SmartReadingList.class})
    Set<SmartListMatcher> smartListMatchers = new HashSet<SmartListMatcher>();

    @Generated
    public SmartListMatcher() {
    }

    @Generated
    public SmartListMatcher(@NonNull SmartReadingList smartList) {
        if (smartList == null) {
            throw new NullPointerException("smartList is marked non-null but is null");
        }
        this.smartList = smartList;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @NonNull
    @Generated
    public SmartReadingList getSmartList() {
        return this.smartList;
    }

    @JsonIgnore
    @JsonView(value={View.SmartReadingList.class})
    @Generated
    public void setSmartList(@NonNull SmartReadingList smartList) {
        if (smartList == null) {
            throw new NullPointerException("smartList is marked non-null but is null");
        }
        this.smartList = smartList;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonView(value={View.SmartReadingList.class})
    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public boolean isNot() {
        return this.not;
    }

    @JsonProperty(value="negative")
    @JsonView(value={View.SmartReadingList.class})
    @Generated
    public void setNot(boolean not) {
        this.not = not;
    }

    @Generated
    public String getMode() {
        return this.mode;
    }

    @JsonProperty(value="mode")
    @JsonView(value={View.SmartReadingList.class})
    @Generated
    public void setMode(String mode) {
        this.mode = mode;
    }

    @Generated
    public String getOperator() {
        return this.operator;
    }

    @JsonProperty(value="operator")
    @JsonView(value={View.SmartReadingList.class})
    @Generated
    public void setOperator(String operator) {
        this.operator = operator;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    @JsonView(value={View.SmartReadingList.class})
    @Generated
    public void setValue(String value) {
        this.value = value;
    }

    @Generated
    public SmartListMatcher getNextMatcher() {
        return this.nextMatcher;
    }

    @JsonIgnore
    @JsonView(value={View.SmartReadingList.class})
    @Generated
    public void setNextMatcher(SmartListMatcher nextMatcher) {
        this.nextMatcher = nextMatcher;
    }

    @Generated
    public Set<SmartListMatcher> getSmartListMatchers() {
        return this.smartListMatchers;
    }
}

