/*
 * Decompiled with CFR 0.152.
 */
package org.comixedproject.model.library;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.util.Date;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import lombok.Generated;
import lombok.NonNull;
import org.comixedproject.model.comicbooks.ComicDetail;
import org.comixedproject.model.user.ComiXedUser;
import org.comixedproject.views.View;
import org.springframework.data.annotation.CreatedDate;

@Entity
@Table(name="LastReadDates")
@JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
public class LastRead {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @JsonView(value={View.UserDetailsView.class, View.ComicDetailsView.class})
    private Long id;
    @ManyToOne
    @JoinColumn(name="ComicDetailId", insertable=true, updatable=false, nullable=false)
    @JsonProperty(value="comicDetail")
    @JsonView(value={View.ComicDetailsView.class})
    @NonNull
    private ComicDetail comicDetail;
    @ManyToOne
    @JoinColumn(name="UserId", insertable=true, updatable=false, nullable=false)
    @NonNull
    private ComiXedUser user;
    @Column(name="LastReadOn", insertable=true, updatable=false, nullable=false)
    @JsonProperty(value="lastRead")
    @JsonFormat(shape=JsonFormat.Shape.NUMBER_INT)
    @JsonView(value={View.ComicDetailsView.class})
    private Date lastReadOn = new Date();
    @Column(name="CreatedOn", updatable=false, nullable=false)
    @CreatedDate
    @JsonView(value={View.ComicDetailsView.class})
    private Date createdOn = new Date();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LastRead that = (LastRead)o;
        return Objects.equals(this.comicDetail, that.comicDetail) && Objects.equals(this.user, that.user) && Objects.equals(this.lastReadOn, that.lastReadOn);
    }

    public int hashCode() {
        return Objects.hash(this.comicDetail, this.user, this.lastReadOn);
    }

    @Generated
    public LastRead() {
    }

    @Generated
    public LastRead(@NonNull ComicDetail comicDetail, @NonNull ComiXedUser user) {
        if (comicDetail == null) {
            throw new NullPointerException("comicDetail is marked non-null but is null");
        }
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        this.comicDetail = comicDetail;
        this.user = user;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @NonNull
    @Generated
    public ComicDetail getComicDetail() {
        return this.comicDetail;
    }

    @JsonProperty(value="comicDetail")
    @JsonView(value={View.ComicDetailsView.class})
    @Generated
    public void setComicDetail(@NonNull ComicDetail comicDetail) {
        if (comicDetail == null) {
            throw new NullPointerException("comicDetail is marked non-null but is null");
        }
        this.comicDetail = comicDetail;
    }

    @NonNull
    @Generated
    public ComiXedUser getUser() {
        return this.user;
    }

    @Generated
    public void setUser(@NonNull ComiXedUser user) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        this.user = user;
    }

    @Generated
    public Date getLastReadOn() {
        return this.lastReadOn;
    }

    @JsonProperty(value="lastRead")
    @JsonFormat(shape=JsonFormat.Shape.NUMBER_INT)
    @JsonView(value={View.ComicDetailsView.class})
    @Generated
    public void setLastReadOn(Date lastReadOn) {
        this.lastReadOn = lastReadOn;
    }

    @Generated
    public Date getCreatedOn() {
        return this.createdOn;
    }
}

