/*
 * Decompiled with CFR 0.152.
 */
package org.comixedproject.model.comicpages;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.comixedproject.model.comicbooks.ComicBook;
import org.comixedproject.model.comicpages.PageState;
import org.comixedproject.views.View;
import org.hibernate.annotations.Formula;

@Entity
@Table(name="Pages")
@JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
public class Page {
    @Generated
    private static final Logger log = LogManager.getLogger(Page.class);
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @JsonProperty(value="id")
    @JsonView(value={View.ComicDetailsView.class})
    private Long id;
    @ManyToOne
    @JoinColumn(name="ComicBookId")
    @JsonProperty(value="comicBook")
    @NonNull
    private ComicBook comicBook;
    @Column(name="PageState", nullable=false, updatable=true)
    @Enumerated(value=EnumType.STRING)
    @NonNull
    private PageState pageState = PageState.STABLE;
    @Column(name="Filename", length=1024, updatable=true, nullable=false)
    @JsonProperty(value="filename")
    @JsonView(value={View.ComicListView.class})
    @NonNull
    private String filename;
    @Column(name="FileHash", length=32, updatable=true, nullable=false)
    @JsonProperty(value="hash")
    @JsonView(value={View.ComicListView.class})
    private String hash;
    @Column(name="PageNumber", nullable=false, updatable=true)
    @JsonProperty(value="pageNumber")
    @JsonView(value={View.ComicDetailsView.class})
    @NonNull
    private Integer pageNumber;
    @Column(name="Width", updatable=true)
    @JsonProperty(value="width")
    @JsonView(value={View.ComicDetailsView.class})
    private Integer width = -1;
    @Column(name="Height", updatable=true)
    @JsonProperty(value="height")
    @JsonView(value={View.ComicDetailsView.class})
    private Integer height = -1;
    @Formula(value="(SELECT CASE WHEN (FileHash IN (SELECT b.hash FROM BlockedHashes b)) THEN true ELSE false END)")
    @JsonProperty(value="blocked")
    @JsonView(value={View.ComicListView.class})
    private boolean blocked;

    @Transient
    @JsonProperty(value="index")
    @JsonView(value={View.ComicDetailsView.class})
    public int getIndex() {
        return this.comicBook.getIndexFor(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Page page = (Page)o;
        return this.pageState == page.pageState && this.filename.equals(page.filename) && this.hash.equals(page.hash) && this.pageNumber.equals(page.pageNumber);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.pageState, this.filename, this.hash, this.pageNumber});
    }

    @Transient
    @JsonProperty(value="deleted")
    @JsonView(value={View.ComicListView.class})
    public boolean isDeleted() {
        return PageState.DELETED.equals((Object)this.pageState);
    }

    @Generated
    public Page() {
    }

    @Generated
    public Page(@NonNull ComicBook comicBook, @NonNull String filename, @NonNull Integer pageNumber) {
        if (comicBook == null) {
            throw new NullPointerException("comicBook is marked non-null but is null");
        }
        if (filename == null) {
            throw new NullPointerException("filename is marked non-null but is null");
        }
        if (pageNumber == null) {
            throw new NullPointerException("pageNumber is marked non-null but is null");
        }
        this.comicBook = comicBook;
        this.filename = filename;
        this.pageNumber = pageNumber;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @NonNull
    @Generated
    public ComicBook getComicBook() {
        return this.comicBook;
    }

    @JsonProperty(value="comicBook")
    @Generated
    public void setComicBook(@NonNull ComicBook comicBook) {
        if (comicBook == null) {
            throw new NullPointerException("comicBook is marked non-null but is null");
        }
        this.comicBook = comicBook;
    }

    @NonNull
    @Generated
    public PageState getPageState() {
        return this.pageState;
    }

    @Generated
    public void setPageState(@NonNull PageState pageState) {
        if (pageState == null) {
            throw new NullPointerException("pageState is marked non-null but is null");
        }
        this.pageState = pageState;
    }

    @NonNull
    @Generated
    public String getFilename() {
        return this.filename;
    }

    @JsonProperty(value="filename")
    @JsonView(value={View.ComicListView.class})
    @Generated
    public void setFilename(@NonNull String filename) {
        if (filename == null) {
            throw new NullPointerException("filename is marked non-null but is null");
        }
        this.filename = filename;
    }

    @Generated
    public String getHash() {
        return this.hash;
    }

    @JsonProperty(value="hash")
    @JsonView(value={View.ComicListView.class})
    @Generated
    public void setHash(String hash) {
        this.hash = hash;
    }

    @NonNull
    @Generated
    public Integer getPageNumber() {
        return this.pageNumber;
    }

    @JsonProperty(value="pageNumber")
    @JsonView(value={View.ComicDetailsView.class})
    @Generated
    public void setPageNumber(@NonNull Integer pageNumber) {
        if (pageNumber == null) {
            throw new NullPointerException("pageNumber is marked non-null but is null");
        }
        this.pageNumber = pageNumber;
    }

    @Generated
    public Integer getWidth() {
        return this.width;
    }

    @JsonProperty(value="width")
    @JsonView(value={View.ComicDetailsView.class})
    @Generated
    public void setWidth(Integer width) {
        this.width = width;
    }

    @Generated
    public Integer getHeight() {
        return this.height;
    }

    @JsonProperty(value="height")
    @JsonView(value={View.ComicDetailsView.class})
    @Generated
    public void setHeight(Integer height) {
        this.height = height;
    }

    @Generated
    public boolean isBlocked() {
        return this.blocked;
    }
}

